<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class PrincipalPhoneNumber extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $phoneNumber;

    /**
     * @var \DateTime|null
     */
    protected $validated;

    /**
     * @var PhoneValidationMethodEnum|null
     */
    protected $validationMethod;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getPhoneNumber(): string
    {
        return $this->phoneNumber;
    }

    public function setPhoneNumber(string $phoneNumber): self
    {
        $this->initialized['phoneNumber'] = true;
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    public function getValidated(): ?\DateTime
    {
        return $this->validated;
    }

    public function setValidated(?\DateTime $validated): self
    {
        $this->initialized['validated'] = true;
        $this->validated = $validated;

        return $this;
    }

    public function getValidationMethod(): ?PhoneValidationMethodEnum
    {
        return $this->validationMethod;
    }

    public function setValidationMethod(?PhoneValidationMethodEnum $validationMethod): self
    {
        $this->initialized['validationMethod'] = true;
        $this->validationMethod = $validationMethod;

        return $this;
    }
}
