<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class OpeningPeriodRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Opening Hour - Request Model.
     *
     * @var OpeningHourRequest
     */
    protected $start;

    /**
     * Opening Hour - Request Model.
     *
     * @var OpeningHourRequest
     */
    protected $end;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Opening Hour - Request Model.
     */
    public function getStart(): OpeningHourRequest
    {
        return $this->start;
    }

    /**
     * Opening Hour - Request Model.
     */
    public function setStart(OpeningHourRequest $start): self
    {
        $this->initialized['start'] = true;
        $this->start = $start;

        return $this;
    }

    /**
     * Opening Hour - Request Model.
     */
    public function getEnd(): OpeningHourRequest
    {
        return $this->end;
    }

    /**
     * Opening Hour - Request Model.
     */
    public function setEnd(OpeningHourRequest $end): self
    {
        $this->initialized['end'] = true;
        $this->end = $end;

        return $this;
    }
}
