<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class LegalStructureResponseComponentsSchemasLegalStructureResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string|null
     */
    protected $apeCode;

    /**
     * @var PostalAddressResponse|null
     */
    protected $headQuarterAddress;

    /**
     * @var string
     */
    protected $legalCode;

    /**
     * @var string
     */
    protected $legalForm;

    /**
     * @var string
     */
    protected $socialReason;

    /**
     * @var string|null
     */
    protected $tradeName;

    /**
     * @var string|null
     */
    protected $vatIntraCommunityNumber;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getApeCode(): ?string
    {
        return $this->apeCode;
    }

    public function setApeCode(?string $apeCode): self
    {
        $this->initialized['apeCode'] = true;
        $this->apeCode = $apeCode;

        return $this;
    }

    public function getHeadQuarterAddress(): ?PostalAddressResponse
    {
        return $this->headQuarterAddress;
    }

    public function setHeadQuarterAddress(?PostalAddressResponse $headQuarterAddress): self
    {
        $this->initialized['headQuarterAddress'] = true;
        $this->headQuarterAddress = $headQuarterAddress;

        return $this;
    }

    public function getLegalCode(): string
    {
        return $this->legalCode;
    }

    public function setLegalCode(string $legalCode): self
    {
        $this->initialized['legalCode'] = true;
        $this->legalCode = $legalCode;

        return $this;
    }

    public function getLegalForm(): string
    {
        return $this->legalForm;
    }

    public function setLegalForm(string $legalForm): self
    {
        $this->initialized['legalForm'] = true;
        $this->legalForm = $legalForm;

        return $this;
    }

    public function getSocialReason(): string
    {
        return $this->socialReason;
    }

    public function setSocialReason(string $socialReason): self
    {
        $this->initialized['socialReason'] = true;
        $this->socialReason = $socialReason;

        return $this;
    }

    public function getTradeName(): ?string
    {
        return $this->tradeName;
    }

    public function setTradeName(?string $tradeName): self
    {
        $this->initialized['tradeName'] = true;
        $this->tradeName = $tradeName;

        return $this;
    }

    public function getVatIntraCommunityNumber(): ?string
    {
        return $this->vatIntraCommunityNumber;
    }

    public function setVatIntraCommunityNumber(?string $vatIntraCommunityNumber): self
    {
        $this->initialized['vatIntraCommunityNumber'] = true;
        $this->vatIntraCommunityNumber = $vatIntraCommunityNumber;

        return $this;
    }
}
