<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class InvoiceDirectDebitRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Invoice Category.
     *
     * @var string
     */
    protected $category;

    /**
     * @var string
     */
    protected $code;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $fromInvoice;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $toInvoice;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Invoice Category.
     */
    public function getCategory(): string
    {
        return $this->category;
    }

    /**
     * Invoice Category.
     */
    public function setCategory(string $category): self
    {
        $this->initialized['category'] = true;
        $this->category = $category;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getFromInvoice(): IdRequest
    {
        return $this->fromInvoice;
    }

    /**
     * Id - Common Request Model.
     */
    public function setFromInvoice(IdRequest $fromInvoice): self
    {
        $this->initialized['fromInvoice'] = true;
        $this->fromInvoice = $fromInvoice;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getToInvoice(): IdRequest
    {
        return $this->toInvoice;
    }

    /**
     * Id - Common Request Model.
     */
    public function setToInvoice(IdRequest $toInvoice): self
    {
        $this->initialized['toInvoice'] = true;
        $this->toInvoice = $toInvoice;

        return $this;
    }
}
