<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class GrantedPermissionShort extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Resource or ResourceGroup slug.
     *
     * @var string
     */
    protected $resource;

    /**
     * Permission or PermissionGroup slug.
     *
     * @var string
     */
    protected $permission;

    /**
     * Permission or PermissionGroup slug.
     *
     * @var string
     */
    protected $principal;

    /**
     * 1 to allow the permission, -1 to deny the permission.
     *
     * @var int
     */
    protected $grantType;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Resource or ResourceGroup slug.
     */
    public function getResource(): string
    {
        return $this->resource;
    }

    /**
     * Resource or ResourceGroup slug.
     */
    public function setResource(string $resource): self
    {
        $this->initialized['resource'] = true;
        $this->resource = $resource;

        return $this;
    }

    /**
     * Permission or PermissionGroup slug.
     */
    public function getPermission(): string
    {
        return $this->permission;
    }

    /**
     * Permission or PermissionGroup slug.
     */
    public function setPermission(string $permission): self
    {
        $this->initialized['permission'] = true;
        $this->permission = $permission;

        return $this;
    }

    /**
     * Permission or PermissionGroup slug.
     */
    public function getPrincipal(): string
    {
        return $this->principal;
    }

    /**
     * Permission or PermissionGroup slug.
     */
    public function setPrincipal(string $principal): self
    {
        $this->initialized['principal'] = true;
        $this->principal = $principal;

        return $this;
    }

    /**
     * 1 to allow the permission, -1 to deny the permission.
     */
    public function getGrantType(): int
    {
        return $this->grantType;
    }

    /**
     * 1 to allow the permission, -1 to deny the permission.
     */
    public function setGrantType(int $grantType): self
    {
        $this->initialized['grantType'] = true;
        $this->grantType = $grantType;

        return $this;
    }
}
