<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class CreditNoteRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $accountingCode;

    /**
     * @var InvoiceAddressRequest
     */
    protected $deliveryAddress;

    /**
     * @var CreditNoteRequestDeliveryInformation
     */
    protected $deliveryInformation;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var list<IdRequest>
     */
    protected $invoiceLines;

    /**
     * @var string|null
     */
    protected $personalisedMention;

    /**
     * @var InvoiceAddressRequest
     */
    protected $receiverAddress;

    /**
     * @var CreditNoteRequestReceiverInformation
     */
    protected $receiverInformation;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getAccountingCode(): string
    {
        return $this->accountingCode;
    }

    public function setAccountingCode(string $accountingCode): self
    {
        $this->initialized['accountingCode'] = true;
        $this->accountingCode = $accountingCode;

        return $this;
    }

    public function getDeliveryAddress(): InvoiceAddressRequest
    {
        return $this->deliveryAddress;
    }

    public function setDeliveryAddress(InvoiceAddressRequest $deliveryAddress): self
    {
        $this->initialized['deliveryAddress'] = true;
        $this->deliveryAddress = $deliveryAddress;

        return $this;
    }

    public function getDeliveryInformation(): CreditNoteRequestDeliveryInformation
    {
        return $this->deliveryInformation;
    }

    public function setDeliveryInformation(CreditNoteRequestDeliveryInformation $deliveryInformation): self
    {
        $this->initialized['deliveryInformation'] = true;
        $this->deliveryInformation = $deliveryInformation;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    /**
     * @return list<IdRequest>
     */
    public function getInvoiceLines(): array
    {
        return $this->invoiceLines;
    }

    /**
     * @param list<IdRequest> $invoiceLines
     */
    public function setInvoiceLines(array $invoiceLines): self
    {
        $this->initialized['invoiceLines'] = true;
        $this->invoiceLines = $invoiceLines;

        return $this;
    }

    public function getPersonalisedMention(): ?string
    {
        return $this->personalisedMention;
    }

    public function setPersonalisedMention(?string $personalisedMention): self
    {
        $this->initialized['personalisedMention'] = true;
        $this->personalisedMention = $personalisedMention;

        return $this;
    }

    public function getReceiverAddress(): InvoiceAddressRequest
    {
        return $this->receiverAddress;
    }

    public function setReceiverAddress(InvoiceAddressRequest $receiverAddress): self
    {
        $this->initialized['receiverAddress'] = true;
        $this->receiverAddress = $receiverAddress;

        return $this;
    }

    public function getReceiverInformation(): CreditNoteRequestReceiverInformation
    {
        return $this->receiverInformation;
    }

    public function setReceiverInformation(CreditNoteRequestReceiverInformation $receiverInformation): self
    {
        $this->initialized['receiverInformation'] = true;
        $this->receiverInformation = $receiverInformation;

        return $this;
    }
}
