<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Exception;

class RevokeBadRequestException extends BadRequestException
{
    /**
     * @var \NoahVet\Reef\Jane\Model\OauthV2RevokeGetResponse400
     */
    private $oauthV2RevokeGetResponse400;

    /**
     * @var \Psr\Http\Message\ResponseInterface
     */
    private $response;

    public function __construct(\NoahVet\Reef\Jane\Model\OauthV2RevokeGetResponse400 $oauthV2RevokeGetResponse400, \Psr\Http\Message\ResponseInterface $response)
    {
        parent::__construct('Wrong or missing parameters');
        $this->oauthV2RevokeGetResponse400 = $oauthV2RevokeGetResponse400;
        $this->response = $response;
    }

    public function getOauthV2RevokeGetResponse400(): \NoahVet\Reef\Jane\Model\OauthV2RevokeGetResponse400
    {
        return $this->oauthV2RevokeGetResponse400;
    }

    public function getResponse(): \Psr\Http\Message\ResponseInterface
    {
        return $this->response;
    }
}
