<?php

declare(strict_types=1);

namespace NoahVet\Reef\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class CachePoolTaggingCompilerPass implements CompilerPassInterface
{
    public function process(ContainerBuilder $container): void
    {
        $cachePoolServices = \array_keys($container->findTaggedServiceIds('cache.pool'));

        foreach ($cachePoolServices as $serviceId) {
            $serviceDefinition = $container->getDefinition($serviceId);
            if ($serviceDefinition->isAbstract()) {
                continue;
            }

            $serviceDefinition->addTag('reef.cache.pool', ['service_id' => $serviceId]);
        }
    }
}
