<?php

declare(strict_types=1);

namespace NoahVet\Reef\BusinessRule\Doctrine;

use NoahVet\Reef\Entity\DisableInterface;
use NoahVet\Reef\Repository\BaseRepositoryInterface;

interface EntityBusinessRuleInterface
{
    /**
     * @template EntityType of object
     * @template ExceptionType of \Exception
     *
     * @param array<string, mixed>                $params
     * @param BaseRepositoryInterface<EntityType> $repository
     * @param class-string<ExceptionType>         $exceptionFQCN
     *
     * @return EntityType
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldBeExist(
        array $params,
        BaseRepositoryInterface $repository,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = null,
    ): object;

    /**
     * @template EntityType of object
     * @template ExceptionType of \Exception
     *
     * @param BaseRepositoryInterface<EntityType> $repository
     * @param class-string<ExceptionType>         $exceptionFQCN
     *
     * @return EntityType
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldBeExistById(
        string $id,
        BaseRepositoryInterface $repository,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = null,
    ): object;

    /**
     * @template EntityType of object
     * @template ExceptionType of \Exception
     *
     * @param BaseRepositoryInterface<EntityType> $repository
     * @param array<string, mixed>                $params
     * @param class-string<ExceptionType>         $exceptionFQCN
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldNotBeExist(
        array $params,
        BaseRepositoryInterface $repository,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = null,
    ): self;

    /**
     * @template ExceptionType of \Exception
     *
     * @param class-string<ExceptionType> $exceptionFQCN
     *
     * @psalm-suppress UnsafeInstantiation
     */
    public function entityShouldNotBeDisabled(
        DisableInterface $entity,
        string $exceptionFQCN = \LogicException::class,
        ?string $exceptionMessage = 'This entity is disabled.',
    ): self;
}
