<?php

declare(strict_types=1);

namespace NoahVet\Reef\Business\Model;

use NoahVet\Reef\Security\Policy\PolicySubjectInterface;

abstract class AbstractEntityWithTeam implements PolicySubjectInterface
{
    /**
     * @param TeamMember[] $teamMembers
     */
    public function __construct(
        protected string $uuid,
        protected string $code,
        protected array $teamMembers,
    ) {
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return TeamMember[]
     */
    public function getTeamMembers(): array
    {
        return $this->teamMembers;
    }
}
