<?php

declare(strict_types=1);

namespace NoahVet\Reef\Bridge\Reef\IAM\Factory;

interface IAMFactoryFacadeInterface
{
    public const BSM_RESOURCE_PREFIX = 'reef:bsmApi:';
    public const IAM_RESOURCE_PREFIX = 'reef:iam:';
    public const IAM_SUPER_ADMIN_SLUG = self::IAM_RESOURCE_PREFIX.'principals:superAdmins';
    public const NEXTCLOUD_RESOURCE_PREFIX = 'reef:nextcloud:';

    public function createResourceByAdmin(string $resourceType, string $id): self;

    public function createResourceByConnectedUser(string $resourceType, string $id): self;
}
