<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Security\IAM\Mapper;

use NoahVet\Reef\Security\IAM\Mapper\IAMResourceMapper;
use NoahVet\Reef\Security\IAM\Mapper\InternalResourceMapperInterface;
use NoahVet\Reef\Security\IAM\Model\Resource;
use PHPUnit\Framework\TestCase;

class IAMMapperTest extends TestCase
{
    public function testMappableResource(): void
    {
        $resourceMapperMock = $this->getMockBuilder(InternalResourceMapperInterface::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $resourceMapperMock
            ->method('canMap')
            ->with('mappableResource')
            ->willReturn(true)
        ;

        $resourceMapperMock
            ->method('mapResource')
            ->with('mappableResource')
            ->willReturn(Resource::fromString('reef:phpunit:resource', 'mappable'))
        ;

        $iamMapper = new IAMResourceMapper([$resourceMapperMock]);

        $resource = $iamMapper->map('mappableResource');
        self::assertInstanceOf(Resource::class, $resource);
        self::assertSame('reef:phpunit:resource:mappable', (string) $resource);
    }

    public function testNonMappableResource(): void
    {
        $resourceMapperMock = $this->getMockBuilder(InternalResourceMapperInterface::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $resourceMapperMock
            ->method('canMap')
            ->with('mappableResource')
            ->willReturn(false)
        ;

        $iamMapper = new IAMResourceMapper([$resourceMapperMock]);

        $resource = $iamMapper->map('mappableResource');
        self::assertNull($resource);
    }
}
