<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Security\IAM\Finder;

use NoahVet\Reef\Security\IAM\Finder\ResourceFinderEnumeratorInterface;
use NoahVet\Reef\Security\IAM\Finder\ResourceFinderManager;
use NoahVet\Reef\Security\IAM\Finder\ReverseResourceFinderInterface;
use NoahVet\Reef\Security\IAM\Model\Resource;
use PHPUnit\Framework\TestCase;

class ResourceFinderManagerTest extends TestCase
{
    public function testCreateIterator(): void
    {
        $resourceA = Resource::fromString('reef:iam:testRt', 'testResource');

        $enumerator = \Mockery::mock(ResourceFinderEnumeratorInterface::class)
            ->shouldReceive('enumerate')
            ->withNoArgs()
            ->andYield($resourceA)
            ->getMock()
        ;

        $resourceB = Resource::fromString('reef:iam:testRt', 'testResource2');

        $enumerator2 = \Mockery::mock(ResourceFinderEnumeratorInterface::class)
            ->shouldReceive('enumerate')
            ->withNoArgs()
            ->andYield($resourceB)
            ->getMock()
        ;

        $resourceManager = new ResourceFinderManager([$enumerator, $enumerator2]);

        self::assertEquals([$resourceA, $resourceB], \iterator_to_array($resourceManager->createIterator()->iterate()));
    }

    public function testFindBySlug(): void
    {
        $reverseFinder = \Mockery::mock(ReverseResourceFinderInterface::class)
            ->shouldReceive('findBySlug')
            ->withArgs(['reef:api:testResourceType:testResource'])
            ->andReturnNull()
            ->getMock()
        ;

        $reverseFinder2 = \Mockery::mock(ReverseResourceFinderInterface::class)
            ->shouldReceive('findBySlug')
            ->withArgs(['reef:api:testResourceType:testResource'])
            ->andReturn('a')
            ->getMock()
        ;

        $resourceManager = new ResourceFinderManager([$reverseFinder, $reverseFinder2]);

        self::assertEquals('a', $resourceManager->findBySlug('reef:api:testResourceType:testResource'));
    }
}
