<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Domain\Tool;

use NoahVet\Reef\Domain\Tool\ArrayTool;
use NoahVet\Reef\Domain\Tool\ArrayToolInterface;
use PHPUnit\Framework\TestCase;

final class ArrayToolTest extends TestCase
{
    private ArrayToolInterface $subject;

    protected function setUp(): void
    {
        $this->subject = new ArrayTool();
    }

    public function testRemoveDeepDuplicateValues(): void
    {
        $before = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            1 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            2 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];
        $expected = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];

        self::assertSame(
            $expected,
            $this->subject::removeDeepDuplicateValues($before, 'id'),
        );
    }

    public function testRemoveDuplicateValues(): void
    {
        $before = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            1 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
            2 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];
        $expected = [
            0 => [
                'id' => 'eb0220aa-8731-4afe-9a62-e6c3fa13b7f2',
            ],
        ];
        /** @var \Traversable $result */
        $result = $this->subject::removeDuplicates($before, 'id');

        self::assertSame(
            $expected,
            \iterator_to_array($result),
        );
    }

    public function testApplyTrimRecursiveWhenDataIsArray(): void
    {
        $data = [
            0 => [
                'id' => ' azerty123456789-_+ ',
            ],
            1 => [
                'id' => 'azerty123456789-_+  ',
            ],
            2 => [
                'id' => 'azerty123456789-_+  ',
            ],
            3 => [
                'id' => '            ',
            ],
            4 => [
                'id' => '    o        ',
            ],
            5 => null,
            6 => true,
            7 => false,
        ];

        $expected = [
            0 => [
                'id' => 'azerty123456789-_+',
            ],
            1 => [
                'id' => 'azerty123456789-_+',
            ],
            2 => [
                'id' => 'azerty123456789-_+',
            ],
            3 => [
                'id' => '',
            ],
            4 => [
                'id' => 'o',
            ],
            5 => null,
            6 => true,
            7 => false,
        ];
        $this->subject::applyTrimRecursive($data);

        //        dd($expected, $data);
        self::assertSame(
            $expected,
            $data,
        );
    }

    public function testApplyTrimRecursiveWhenDataIsString(): void
    {
        $data = "  azerty01234567989-é'(è'(&'   ";
        $expected = "azerty01234567989-é'(è'(&'";

        $this->subject::applyTrimRecursive($data);

        self::assertSame(
            $expected,
            $data,
        );
    }

    public function testApplyTrimRecursiveWhenDataIsNull(): void
    {
        $data = null;
        $expected = null;

        $this->subject::applyTrimRecursive($data);

        self::assertSame(
            $expected,
            $data,
        );
    }
}
