<?php

declare(strict_types=1);

namespace NoahVet\Reef\Test\A_Unit\Business\Enumerator;

use NoahVet\Reef\Business\Enumerator\VeterinaryGroupEnumerator;
use NoahVet\Reef\Jane\Client;
use NoahVet\Reef\Jane\Model\VeterinaryGroupResponseItem;
use PHPUnit\Framework\TestCase;
use Psr\Http\Client\NetworkExceptionInterface;

class VeterinaryGroupEnumeratorTest extends TestCase
{
    public function testEnumerateApiDown(): void
    {
        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $client
            ->method('getAllVeterinaryGroup')
            ->withAnyParameters()
            ->willThrowException(
                $this
                    ->getMockBuilder(NetworkExceptionInterface::class)
                    ->disableOriginalConstructor()
                    ->getMock(),
            )
        ;

        $enumerator = new VeterinaryGroupEnumerator($client);

        self::expectException(NetworkExceptionInterface::class);

        \iterator_to_array($enumerator->enumerateAll());
    }

    public function testEnumerateAll(): void
    {
        $client = $this->getMockBuilder(Client::class)
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $group = new VeterinaryGroupResponseItem();

        $client
            ->expects(self::exactly(1))
            ->method('getAllVeterinaryGroup')
            ->withConsecutive(
                [['page' => 0, 'limit' => 50]],
            )
            ->willReturnOnConsecutiveCalls(
                [$group],
            )
        ;

        $enumerator = new VeterinaryGroupEnumerator($client);

        $groups = \iterator_to_array($enumerator->enumerateAll());
        self::assertCount(1, $groups);
        self::assertSame($group, $groups[0]);
    }
}
