<?php

declare(strict_types=1);

namespace NoahVet\Reef\Traits\Entity\Required;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Uid\Uuid;

trait IdTrait
{
    #[ORM\Id]
    #[ORM\Column(type: 'uuid', nullable: false)]
    private Uuid $id;

    public function __construct(Uuid $id = null)
    {
        $this->id = $id ?? Uuid::v6();
    }

    public function getId(): Uuid
    {
        return $this->id;
    }
}
