<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Policy;

use NoahVet\Reef\Security\IAM\Model\ResourceType;

class PolicyResult
{
    public ?string $etag = null;

    protected string $policyName;

    protected string $subject;

    protected ResourceType $resourceType;

    /**
     * @var array<int, PolicyResultGrant>
     */
    protected array $grants = [];

    public function __construct(
        string $policyName,
        string $subject,
        ResourceType $resourceType,
    ) {
        $this->policyName = $policyName;
        $this->subject = $subject;
        $this->resourceType = $resourceType;
    }

    public function getPolicyName(): string
    {
        return $this->policyName;
    }

    public function getSubject(): string
    {
        return $this->subject;
    }

    public function getResourceType(): ResourceType
    {
        return $this->resourceType;
    }

    public function addGrant(PolicyResultGrant $grant): void
    {
        $this->grants[] = $grant;
    }

    /**
     * @return array<int, PolicyResultGrant>
     */
    public function getGrants(): array
    {
        return $this->grants;
    }
}
