<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\Policy;

use NoahVet\Reef\Factory\ClientFactory;
use NoahVet\Reef\Security\Authentication\BearerClientHMacComputer;
use NoahVet\Reef\Security\IAM\Transformer\PolicyResultTransformer;

class PolicyManagerFactory
{
    protected BearerClientHMacComputer $bearerClientHMacComputer;

    protected ClientFactory $clientFactory;

    /**
     * @var iterable<PolicyInterface>
     */
    protected iterable $policies;

    protected PolicyResultTransformer $policyResultTransformer;

    /**
     * @param iterable<PolicyInterface> $policies
     */
    public function __construct(
        BearerClientHMacComputer $bearerClientHMacComputer,
        ClientFactory $clientFactory,
        iterable $policies,
        PolicyResultTransformer $policyResultTransformer,
    ) {
        $this->bearerClientHMacComputer = $bearerClientHMacComputer;
        $this->clientFactory = $clientFactory;
        $this->policies = $policies;
        $this->policyResultTransformer = $policyResultTransformer;
    }

    public function create(string $bearer): PolicyManager
    {
        return new PolicyManager(
            $bearer,
            $this->bearerClientHMacComputer,
            $this->clientFactory,
            $this->policies,
            $this->policyResultTransformer,
        );
    }
}
