<?php

declare(strict_types=1);

namespace NoahVet\Reef\Security\IAM\Generator;

use NoahVet\Reef\Security\IAM\Model\ResourceGroupWithMembers;

/**
 * Allow generation of resource and resources groups for the IAM.
 */
class IAMResourceGenerator
{
    /**
     * @var iterable<InternalGeneratorInterface>
     */
    protected iterable $generators;

    /**
     * @param iterable<InternalGeneratorInterface> $generators
     */
    public function __construct(
        iterable $generators,
    ) {
        $this->generators = $generators;
    }

    /**
     * @return array<\NoahVet\Reef\Security\IAM\Model\Resource|ResourceGroupWithMembers>
     */
    public function generate(mixed $subject): array
    {
        $ret = [];

        foreach ($this->generators as $generator) {
            if (!$generator->canGenerate($subject)) {
                continue;
            }

            if ($generator instanceof InternalResourceGeneratorInterface) {
                $ret[] = $generator->generateResource($subject);
            }

            if ($generator instanceof InternalResourceGroupGeneratorInterface) {
                $ret[] = $generator->generateGroup($subject);
            }
        }

        return $ret;
    }
}
