<?php

declare(strict_types=1);

namespace NoahVet\Reef\RabbitMQ\Notification\Factory;

use NoahVet\Reef\RabbitMQ\Notification\ReefNotification;
use NoahVet\Reef\RabbitMQ\Notification\ReefNotificationInterface;
use NoahVet\Reef\Security\IAM\Model\Resource;

class ReefNotificationFactory implements ReefNotificationFactoryInterface
{
    public function __construct(
        private readonly string $reefClientId,
    ) {
    }

    /**
     * @param array<string, string|int|float|boolean|array<string, string|int|float|boolean>> $rawData
     */
    public function createNotification(
        Resource $resource,
        string $action,
        array $rawData,
    ): ReefNotificationInterface {
        return new ReefNotification(
            $this->reefClientId,
            $resource->getResourceType()->getSlug(),
            $resource->getResourceId(),
            $action,
            $rawData,
        );
    }
}
