<?php

declare(strict_types=1);

namespace NoahVet\Reef\Paginator;

use NoahVet\Reef\Entity\EntityInterface;
use Symfony\Component\HttpFoundation\Request;

interface HttpPaginatorInterface
{
    /**
     * @return array<string, mixed>
     */
    public function getInformation(): array;

    /**
     * @param class-string<EntityInterface> $entityFqcn
     * @param array<string, mixed>          $context
     *
     * @return array<int, EntityInterface>
     */
    public function getResult(
        Request $request,
        string $entityFqcn,
        array $context = [],
        bool $isPaginated = true,
    ): array;

    /**
     * @return array<string, string>
     */
    public function getContentRangeHeader(string $unit): array;
}
