<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One\Update;

use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\Common\One\AbstractOneMapperInterface;

interface AbstractUpdateMapperInterface extends AbstractOneMapperInterface
{
    public function mapDataToRequestDto(
        string $data,
        string $requestDto,
        EntityInterface $existingEntity,
    ): object;

    public function mapRequestDtoToEntity(
        object $requestDto,
    ): EntityInterface;

    public function mapEntityToResponseDto(
        EntityInterface $entity,
        string $responseDtoFqcn,
    ): object;

    /**
     * @return array<string, mixed>
     */
    public function normalizeExistingEntity(
        EntityInterface $entity,
    ): array;
}
