<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One\Update;

use NoahVet\Reef\Domain\Tool\ArrayTool;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\Common\One\AbstractOneMapper;
use Symfony\Component\Serializer\Exception\ExceptionInterface;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;

abstract class AbstractUpdateMapper extends AbstractOneMapper implements AbstractUpdateMapperInterface
{
    /**
     * @var array<string, mixed>
     */
    protected array $payloadAsArray;

    public function mapDataToRequestDto(
        string $data,
        string $requestDto,
        EntityInterface $existingEntity,
    ): object {
        $this->entity = $existingEntity;
        $this->payloadAsArray = $this->serializer->decode(
            $data,
            'json',
        );

        /** @var array<string, mixed> $dataAsArray */
        $dataAsArray = \array_merge(
            $this->normalizeExistingEntity($existingEntity),
            $this->payloadAsArray,
        );

        ArrayTool::applyTrimRecursive($dataAsArray);

        return (object) $this->serializer->denormalize(
            $dataAsArray,
            $requestDto,
            'json',
            [
                AbstractNormalizer::IGNORED_ATTRIBUTES => [
                    'id',
                    'createdDate',
                    'updatedDate',
                ],
            ],
        );
    }

    /**
     * @throws ExceptionInterface
     */
    public function normalizeExistingEntity(
        EntityInterface $entity,
    ): array {
        $data = $this->normalizeEntity($entity);
        $this->postNormalizeEntity($data);

        return $data;
    }
}
