<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\One;

use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\AbstractMapper;
use Symfony\Component\Serializer\Exception\ExceptionInterface;

abstract class AbstractOneMapper extends AbstractMapper implements AbstractOneMapperInterface
{
    protected EntityInterface $entity;

    public function mapEntityToResponseDto(
        EntityInterface $entity,
        string $responseDtoFqcn,
    ): object {
        $data = $this->normalizeEntity($entity);
        $this->postNormalizeEntity($data);

        return $this->serializer->denormalize(
            $data,
            $responseDtoFqcn,
        );
    }

    /**
     * @return array<string, mixed>
     *
     * @throws ExceptionInterface
     */
    public function normalizeEntity(
        EntityInterface $entity,
    ): array {
        return (array) $this->serializer->normalize($entity);
    }

    public function normalizeResponseDto(
        object $responseDto,
    ): array {
        return (array) $this->serializer->normalize($responseDto);
    }

    /**
     * @param array<string, mixed> $data
     */
    protected function postNormalizeEntity(array &$data): void
    {
    }
}
