<?php

declare(strict_types=1);

namespace NoahVet\Reef\Mapper\Common\Many;

use Doctrine\Common\Collections\ArrayCollection;
use NoahVet\Reef\Entity\EntityInterface;
use NoahVet\Reef\Mapper\AbstractMapper;
use Symfony\Component\Serializer\Exception\ExceptionInterface;

abstract class AbstractGetAllMapper extends AbstractMapper implements AbstractGetAllMapperInterface
{
    /**
     * @param array<int, EntityInterface> $data
     *
     * @throws ExceptionInterface
     */
    public function mapDataToResponseDto(
        array $data,
        string $responseDtoFqcn,
    ): mixed {
        $data = $this->normalizeEntities(
            new ArrayCollection($data),
        );

        foreach ($data as &$datum) {
            $this->postNormalizeEntity($datum);
        }

        return $this->serializer->denormalize(
            $data,
            $responseDtoFqcn.'[]',
        );
    }

    public function normalizeResponseDto(
        array $dtoAsArray,
    ): array {
        return (array) $this->serializer->normalize($dtoAsArray);
    }

    /**
     * @param array<string, mixed> $data
     */
    protected function postNormalizeEntity(array &$data): void
    {
    }
}
