<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class VeterinaryEstablishmentMemberResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponseItem' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponseItem' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('entryDate', $data) && null !== $data['entryDate']) {
            $object->setEntryDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['entryDate']));
            unset($data['entryDate']);
        } elseif (\array_key_exists('entryDate', $data) && null === $data['entryDate']) {
            $object->setEntryDate(null);
        }
        if (\array_key_exists('exitDate', $data) && null !== $data['exitDate']) {
            $object->setExitDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['exitDate']));
            unset($data['exitDate']);
        } elseif (\array_key_exists('exitDate', $data) && null === $data['exitDate']) {
            $object->setExitDate(null);
        }
        if (\array_key_exists('ebpCode', $data) && null !== $data['ebpCode']) {
            $object->setEbpCode($data['ebpCode']);
            unset($data['ebpCode']);
        } elseif (\array_key_exists('ebpCode', $data) && null === $data['ebpCode']) {
            $object->setEbpCode(null);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponseItemVeterinaryEstablishment', 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        if (\array_key_exists('veterinaryGroup', $data)) {
            $object->setVeterinaryGroup($this->denormalizer->denormalize($data['veterinaryGroup'], 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponseItemVeterinaryGroup', 'json', $context));
            unset($data['veterinaryGroup']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        if ($object->isInitialized('entryDate') && null !== $object->getEntryDate()) {
            $data['entryDate'] = $object->getEntryDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('exitDate') && null !== $object->getExitDate()) {
            $data['exitDate'] = $object->getExitDate()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('ebpCode') && null !== $object->getEbpCode()) {
            $data['ebpCode'] = $object->getEbpCode();
        }
        $data['veterinaryEstablishment'] = $this->normalizer->normalize($object->getVeterinaryEstablishment(), 'json', $context);
        $data['veterinaryGroup'] = $this->normalizer->normalize($object->getVeterinaryGroup(), 'json', $context);
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentMemberResponseItem' => false];
    }
}
