<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentServiceSubscriptionRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('from', $data)) {
            $object->setFrom(\DateTime::createFromFormat('Y-m-d', $data['from'])->setTime(0, 0, 0));
            unset($data['from']);
        }
        if (\array_key_exists('to', $data)) {
            $object->setTo(\DateTime::createFromFormat('Y-m-d', $data['to'])->setTime(0, 0, 0));
            unset($data['to']);
        }
        if (\array_key_exists('attributes', $data)) {
            $values = [];
            foreach ($data['attributes'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem', 'json', $context);
            }
            $object->setAttributes($values);
            unset($data['attributes']);
        }
        if (\array_key_exists('billingMethod', $data)) {
            $object->setBillingMethod($data['billingMethod']);
            unset($data['billingMethod']);
        }
        if (\array_key_exists('isRenewal', $data)) {
            $object->setIsRenewal($data['isRenewal']);
            unset($data['isRenewal']);
        }
        if (\array_key_exists('billingAccount', $data) && null !== $data['billingAccount']) {
            $object->setBillingAccount($this->denormalizer->denormalize($data['billingAccount'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['billingAccount']);
        } elseif (\array_key_exists('billingAccount', $data) && null === $data['billingAccount']) {
            $object->setBillingAccount(null);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['from'] = $object->getFrom()->format('Y-m-d');
        $data['to'] = $object->getTo()->format('Y-m-d');
        $values = [];
        foreach ($object->getAttributes() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['attributes'] = $values;
        $data['billingMethod'] = $object->getBillingMethod();
        $data['isRenewal'] = $object->getIsRenewal();
        if ($object->isInitialized('billingAccount') && null !== $object->getBillingAccount()) {
            $data['billingAccount'] = $this->normalizer->normalize($object->getBillingAccount(), 'json', $context);
        }
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceSubscriptionRequest' => false];
    }
}
