<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentServiceDeliveryResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryResponse' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryResponse' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('completionDate', $data)) {
            $object->setCompletionDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['completionDate']));
            unset($data['completionDate']);
        }
        if (\array_key_exists('ebpCode', $data) && null !== $data['ebpCode']) {
            $object->setEbpCode($data['ebpCode']);
            unset($data['ebpCode']);
        } elseif (\array_key_exists('ebpCode', $data) && null === $data['ebpCode']) {
            $object->setEbpCode(null);
        }
        if (\array_key_exists('invoiceDate', $data)) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoiceDate']));
            unset($data['invoiceDate']);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('paymentStatus', $data)) {
            $object->setPaymentStatus($data['paymentStatus']);
            unset($data['paymentStatus']);
        }
        if (\array_key_exists('serviceDeliveryOption', $data)) {
            $object->setServiceDeliveryOption($this->denormalizer->denormalize($data['serviceDeliveryOption'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryResponseServiceDeliveryOption', 'json', $context));
            unset($data['serviceDeliveryOption']);
        }
        if (\array_key_exists('unitPriceWithoutVat', $data)) {
            $object->setUnitPriceWithoutVat($data['unitPriceWithoutVat']);
            unset($data['unitPriceWithoutVat']);
        }
        if (\array_key_exists('unitPriceWithVat', $data)) {
            $object->setUnitPriceWithVat($data['unitPriceWithVat']);
            unset($data['unitPriceWithVat']);
        }
        if (\array_key_exists('vat', $data)) {
            $object->setVat($data['vat']);
            unset($data['vat']);
        }
        if (\array_key_exists('veterinaryEstablishment', $data)) {
            $object->setVeterinaryEstablishment($this->denormalizer->denormalize($data['veterinaryEstablishment'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryResponseVeterinaryEstablishment', 'json', $context));
            unset($data['veterinaryEstablishment']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['code'] = $object->getCode();
        $data['completionDate'] = $object->getCompletionDate()->format('Y-m-d\\TH:i:sP');
        $data['ebpCode'] = $object->getEbpCode();
        $data['invoiceDate'] = $object->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        $data['longDescription'] = $object->getLongDescription();
        $data['paymentStatus'] = $object->getPaymentStatus();
        if ($object->isInitialized('serviceDeliveryOption') && null !== $object->getServiceDeliveryOption()) {
            $data['serviceDeliveryOption'] = $this->normalizer->normalize($object->getServiceDeliveryOption(), 'json', $context);
        }
        $data['unitPriceWithoutVat'] = $object->getUnitPriceWithoutVat();
        $data['unitPriceWithVat'] = $object->getUnitPriceWithVat();
        $data['vat'] = $object->getVat();
        if ($object->isInitialized('veterinaryEstablishment') && null !== $object->getVeterinaryEstablishment()) {
            $data['veterinaryEstablishment'] = $this->normalizer->normalize($object->getVeterinaryEstablishment(), 'json', $context);
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentServiceDeliveryResponse' => false];
    }
}
