<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentResponseNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponse' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponse' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentResponse();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponseLegalStructure', 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('mainBillingAccount', $data) && null !== $data['mainBillingAccount']) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponseMainBillingAccount', 'json', $context));
            unset($data['mainBillingAccount']);
        } elseif (\array_key_exists('mainBillingAccount', $data) && null === $data['mainBillingAccount']) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('privilegedCode', $data)) {
            $object->setPrivilegedCode($data['privilegedCode']);
            unset($data['privilegedCode']);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('shortDescription', $data) && null !== $data['shortDescription']) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        } elseif (\array_key_exists('shortDescription', $data) && null === $data['shortDescription']) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponseLogo', 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponseBanner', 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('pictures', $data) && null !== $data['pictures']) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponsePicturesItem', 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        } elseif (\array_key_exists('pictures', $data) && null === $data['pictures']) {
            $object->setPictures(null);
        }
        if (\array_key_exists('schedule', $data) && null !== $data['schedule']) {
            $object->setSchedule($this->denormalizer->denormalize($data['schedule'], 'NoahVet\\Reef\\Jane\\Model\\ScheduleResponse', 'json', $context));
            unset($data['schedule']);
        } elseif (\array_key_exists('schedule', $data) && null === $data['schedule']) {
            $object->setSchedule(null);
        }
        if (\array_key_exists('addresses', $data) && null !== $data['addresses']) {
            $values_1 = [];
            foreach ($data['addresses'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentAddressResponse', 'json', $context);
            }
            $object->setAddresses($values_1);
            unset($data['addresses']);
        } elseif (\array_key_exists('addresses', $data) && null === $data['addresses']) {
            $object->setAddresses(null);
        }
        if (\array_key_exists('tags', $data) && null !== $data['tags']) {
            $values_2 = [];
            foreach ($data['tags'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'NoahVet\\Reef\\Jane\\Model\\TagResponse', 'json', $context);
            }
            $object->setTags($values_2);
            unset($data['tags']);
        } elseif (\array_key_exists('tags', $data) && null === $data['tags']) {
            $object->setTags(null);
        }
        if (\array_key_exists('entryNumber', $data) && null !== $data['entryNumber']) {
            $object->setEntryNumber($data['entryNumber']);
            unset($data['entryNumber']);
        } elseif (\array_key_exists('entryNumber', $data) && null === $data['entryNumber']) {
            $object->setEntryNumber(null);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('mainAddress', $data) && null !== $data['mainAddress']) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdResponse', 'json', $context));
            unset($data['mainAddress']);
        } elseif (\array_key_exists('mainAddress', $data) && null === $data['mainAddress']) {
            $object->setMainAddress(null);
        }
        if (\array_key_exists('activities', $data) && null !== $data['activities']) {
            $values_3 = [];
            foreach ($data['activities'] as $value_3) {
                $values_3[] = $this->denormalizer->denormalize($value_3, 'NoahVet\\Reef\\Jane\\Model\\ActivityResponse', 'json', $context);
            }
            $object->setActivities($values_3);
            unset($data['activities']);
        } elseif (\array_key_exists('activities', $data) && null === $data['activities']) {
            $object->setActivities(null);
        }
        foreach ($data as $key => $value_4) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_4;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['legalStructure'] = $this->normalizer->normalize($object->getLegalStructure(), 'json', $context);
        $data['type'] = $object->getType();
        $data['name'] = $object->getName();
        $data['mainBillingAccount'] = $this->normalizer->normalize($object->getMainBillingAccount(), 'json', $context);
        $data['privilegedCode'] = $object->getPrivilegedCode();
        $data['longDescription'] = $object->getLongDescription();
        $data['shortDescription'] = $object->getShortDescription();
        $data['logo'] = $this->normalizer->normalize($object->getLogo(), 'json', $context);
        $data['banner'] = $this->normalizer->normalize($object->getBanner(), 'json', $context);
        $values = [];
        foreach ($object->getPictures() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['pictures'] = $values;
        $data['schedule'] = $this->normalizer->normalize($object->getSchedule(), 'json', $context);
        if ($object->isInitialized('addresses') && null !== $object->getAddresses()) {
            $values_1 = [];
            foreach ($object->getAddresses() as $value_1) {
                $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
            }
            $data['addresses'] = $values_1;
        }
        $values_2 = [];
        foreach ($object->getTags() as $value_2) {
            $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
        }
        $data['tags'] = $values_2;
        $data['entryNumber'] = $object->getEntryNumber();
        $data['internalCommentary'] = $object->getInternalCommentary();
        $data['mainAddress'] = $this->normalizer->normalize($object->getMainAddress(), 'json', $context);
        if ($object->isInitialized('activities') && null !== $object->getActivities()) {
            $values_3 = [];
            foreach ($object->getActivities() as $value_3) {
                $values_3[] = $this->normalizer->normalize($value_3, 'json', $context);
            }
            $data['activities'] = $values_3;
        }
        foreach ($object as $key => $value_4) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_4;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentResponse' => false];
    }
}
