<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class SchemasVeterinaryEstablishmentRequestNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequest' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequest' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentRequest();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('legalStructure', $data) && null !== $data['legalStructure']) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['legalStructure']);
        } elseif (\array_key_exists('legalStructure', $data) && null === $data['legalStructure']) {
            $object->setLegalStructure(null);
        }
        if (\array_key_exists('type', $data) && null !== $data['type']) {
            $object->setType($data['type']);
            unset($data['type']);
        } elseif (\array_key_exists('type', $data) && null === $data['type']) {
            $object->setType(null);
        }
        if (\array_key_exists('name', $data) && null !== $data['name']) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && null === $data['name']) {
            $object->setName(null);
        }
        if (\array_key_exists('mainBillingAccount', $data) && null !== $data['mainBillingAccount']) {
            $object->setMainBillingAccount($this->denormalizer->denormalize($data['mainBillingAccount'], 'NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequestMainBillingAccount', 'json', $context));
            unset($data['mainBillingAccount']);
        } elseif (\array_key_exists('mainBillingAccount', $data) && null === $data['mainBillingAccount']) {
            $object->setMainBillingAccount(null);
        }
        if (\array_key_exists('longDescription', $data) && null !== $data['longDescription']) {
            $object->setLongDescription($data['longDescription']);
            unset($data['longDescription']);
        } elseif (\array_key_exists('longDescription', $data) && null === $data['longDescription']) {
            $object->setLongDescription(null);
        }
        if (\array_key_exists('shortDescription', $data) && null !== $data['shortDescription']) {
            $object->setShortDescription($data['shortDescription']);
            unset($data['shortDescription']);
        } elseif (\array_key_exists('shortDescription', $data) && null === $data['shortDescription']) {
            $object->setShortDescription(null);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('pictures', $data) && null !== $data['pictures']) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\IdRequest', 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        } elseif (\array_key_exists('pictures', $data) && null === $data['pictures']) {
            $object->setPictures(null);
        }
        if (\array_key_exists('schedule', $data) && null !== $data['schedule']) {
            $object->setSchedule($this->denormalizer->denormalize($data['schedule'], 'NoahVet\\Reef\\Jane\\Model\\ScheduleRequest', 'json', $context));
            unset($data['schedule']);
        } elseif (\array_key_exists('schedule', $data) && null === $data['schedule']) {
            $object->setSchedule(null);
        }
        if (\array_key_exists('tags', $data) && null !== $data['tags']) {
            $values_1 = [];
            foreach ($data['tags'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'NoahVet\\Reef\\Jane\\Model\\IdRequest', 'json', $context);
            }
            $object->setTags($values_1);
            unset($data['tags']);
        } elseif (\array_key_exists('tags', $data) && null === $data['tags']) {
            $object->setTags(null);
        }
        if (\array_key_exists('entryNumber', $data) && null !== $data['entryNumber']) {
            $object->setEntryNumber($data['entryNumber']);
            unset($data['entryNumber']);
        } elseif (\array_key_exists('entryNumber', $data) && null === $data['entryNumber']) {
            $object->setEntryNumber(null);
        }
        if (\array_key_exists('internalCommentary', $data) && null !== $data['internalCommentary']) {
            $object->setInternalCommentary($data['internalCommentary']);
            unset($data['internalCommentary']);
        } elseif (\array_key_exists('internalCommentary', $data) && null === $data['internalCommentary']) {
            $object->setInternalCommentary(null);
        }
        if (\array_key_exists('mainAddress', $data) && null !== $data['mainAddress']) {
            $object->setMainAddress($this->denormalizer->denormalize($data['mainAddress'], 'NoahVet\\Reef\\Jane\\Model\\NullableIdRequest', 'json', $context));
            unset($data['mainAddress']);
        } elseif (\array_key_exists('mainAddress', $data) && null === $data['mainAddress']) {
            $object->setMainAddress(null);
        }
        foreach ($data as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_2;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('legalStructure') && null !== $object->getLegalStructure()) {
            $data['legalStructure'] = $this->normalizer->normalize($object->getLegalStructure(), 'json', $context);
        }
        if ($object->isInitialized('type') && null !== $object->getType()) {
            $data['type'] = $object->getType();
        }
        if ($object->isInitialized('name') && null !== $object->getName()) {
            $data['name'] = $object->getName();
        }
        if ($object->isInitialized('mainBillingAccount') && null !== $object->getMainBillingAccount()) {
            $data['mainBillingAccount'] = $this->normalizer->normalize($object->getMainBillingAccount(), 'json', $context);
        }
        if ($object->isInitialized('longDescription') && null !== $object->getLongDescription()) {
            $data['longDescription'] = $object->getLongDescription();
        }
        if ($object->isInitialized('shortDescription') && null !== $object->getShortDescription()) {
            $data['shortDescription'] = $object->getShortDescription();
        }
        if ($object->isInitialized('logo') && null !== $object->getLogo()) {
            $data['logo'] = $this->normalizer->normalize($object->getLogo(), 'json', $context);
        }
        if ($object->isInitialized('banner') && null !== $object->getBanner()) {
            $data['banner'] = $this->normalizer->normalize($object->getBanner(), 'json', $context);
        }
        if ($object->isInitialized('pictures') && null !== $object->getPictures()) {
            $values = [];
            foreach ($object->getPictures() as $value) {
                $values[] = $this->normalizer->normalize($value, 'json', $context);
            }
            $data['pictures'] = $values;
        }
        if ($object->isInitialized('schedule') && null !== $object->getSchedule()) {
            $data['schedule'] = $this->normalizer->normalize($object->getSchedule(), 'json', $context);
        }
        if ($object->isInitialized('tags') && null !== $object->getTags()) {
            $values_1 = [];
            foreach ($object->getTags() as $value_1) {
                $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
            }
            $data['tags'] = $values_1;
        }
        if ($object->isInitialized('entryNumber') && null !== $object->getEntryNumber()) {
            $data['entryNumber'] = $object->getEntryNumber();
        }
        if ($object->isInitialized('internalCommentary') && null !== $object->getInternalCommentary()) {
            $data['internalCommentary'] = $object->getInternalCommentary();
        }
        if ($object->isInitialized('mainAddress') && null !== $object->getMainAddress()) {
            $data['mainAddress'] = $this->normalizer->normalize($object->getMainAddress(), 'json', $context);
        }
        foreach ($object as $key => $value_2) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_2;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\SchemasVeterinaryEstablishmentRequest' => false];
    }
}
