<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class PrincipalInvitationNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\PrincipalInvitation();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('invited', $data)) {
            $object->setInvited($data['invited']);
            unset($data['invited']);
        }
        if (\array_key_exists('host', $data) && null !== $data['host']) {
            $object->setHost($data['host']);
            unset($data['host']);
        } elseif (\array_key_exists('host', $data) && null === $data['host']) {
            $object->setHost(null);
        }
        if (\array_key_exists('hostClient', $data) && null !== $data['hostClient']) {
            $object->setHostClient($data['hostClient']);
            unset($data['hostClient']);
        } elseif (\array_key_exists('hostClient', $data) && null === $data['hostClient']) {
            $object->setHostClient(null);
        }
        if (\array_key_exists('emailSent', $data) && null !== $data['emailSent']) {
            $object->setEmailSent(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['emailSent']));
            unset($data['emailSent']);
        } elseif (\array_key_exists('emailSent', $data) && null === $data['emailSent']) {
            $object->setEmailSent(null);
        }
        if (\array_key_exists('emailStatus', $data)) {
            $object->setEmailStatus($this->denormalizer->denormalize($data['emailStatus'], 'NoahVet\\Reef\\Jane\\Model\\InvitationEmailStatusEnum', 'json', $context));
            unset($data['emailStatus']);
        }
        if (\array_key_exists('emailLog', $data) && null !== $data['emailLog']) {
            $object->setEmailLog($data['emailLog']);
            unset($data['emailLog']);
        } elseif (\array_key_exists('emailLog', $data) && null === $data['emailLog']) {
            $object->setEmailLog(null);
        }
        if (\array_key_exists('id', $data) && null !== $data['id']) {
            $object->setId($data['id']);
            unset($data['id']);
        } elseif (\array_key_exists('id', $data) && null === $data['id']) {
            $object->setId(null);
        }
        if (\array_key_exists('token', $data)) {
            $object->setToken($data['token']);
            unset($data['token']);
        }
        if (\array_key_exists('created', $data)) {
            $object->setCreated(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['created']));
            unset($data['created']);
        }
        if (\array_key_exists('emailTemplateNumber', $data)) {
            $object->setEmailTemplateNumber($data['emailTemplateNumber']);
            unset($data['emailTemplateNumber']);
        }
        foreach ($data as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        if ($object->isInitialized('invited') && null !== $object->getInvited()) {
            $data['invited'] = $object->getInvited();
        }
        if ($object->isInitialized('host') && null !== $object->getHost()) {
            $data['host'] = $object->getHost();
        }
        if ($object->isInitialized('hostClient') && null !== $object->getHostClient()) {
            $data['hostClient'] = $object->getHostClient();
        }
        if ($object->isInitialized('emailSent') && null !== $object->getEmailSent()) {
            $data['emailSent'] = $object->getEmailSent()->format('Y-m-d\\TH:i:sP');
        }
        if ($object->isInitialized('emailStatus') && null !== $object->getEmailStatus()) {
            $data['emailStatus'] = $this->normalizer->normalize($object->getEmailStatus(), 'json', $context);
        }
        if ($object->isInitialized('emailLog') && null !== $object->getEmailLog()) {
            $data['emailLog'] = $object->getEmailLog();
        }
        if ($object->isInitialized('emailTemplateNumber') && null !== $object->getEmailTemplateNumber()) {
            $data['emailTemplateNumber'] = $object->getEmailTemplateNumber();
        }
        foreach ($object as $key => $value) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\PrincipalInvitation' => false];
    }
}
