<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use NoahVet\Reef\Jane\Runtime\Normalizer\CheckArray;
use NoahVet\Reef\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class ManufacturerResponseItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use CheckArray;
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItem' === $type;
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return \is_object($data) && 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItem' === $data::class;
    }

    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \NoahVet\Reef\Jane\Model\ManufacturerResponseItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('createdDate', $data)) {
            $object->setCreatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['createdDate']));
            unset($data['createdDate']);
        }
        if (\array_key_exists('updatedDate', $data)) {
            $object->setUpdatedDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['updatedDate']));
            unset($data['updatedDate']);
        }
        if (\array_key_exists('banner', $data) && null !== $data['banner']) {
            $object->setBanner($this->denormalizer->denormalize($data['banner'], 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemBanner', 'json', $context));
            unset($data['banner']);
        } elseif (\array_key_exists('banner', $data) && null === $data['banner']) {
            $object->setBanner(null);
        }
        if (\array_key_exists('code', $data)) {
            $object->setCode($data['code']);
            unset($data['code']);
        }
        if (\array_key_exists('legalStructure', $data)) {
            $object->setLegalStructure($this->denormalizer->denormalize($data['legalStructure'], 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemLegalStructure', 'json', $context));
            unset($data['legalStructure']);
        }
        if (\array_key_exists('logo', $data) && null !== $data['logo']) {
            $object->setLogo($this->denormalizer->denormalize($data['logo'], 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemLogo', 'json', $context));
            unset($data['logo']);
        } elseif (\array_key_exists('logo', $data) && null === $data['logo']) {
            $object->setLogo(null);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('pictures', $data) && null !== $data['pictures']) {
            $values = [];
            foreach ($data['pictures'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItemPicturesItem', 'json', $context);
            }
            $object->setPictures($values);
            unset($data['pictures']);
        } elseif (\array_key_exists('pictures', $data) && null === $data['pictures']) {
            $object->setPictures(null);
        }
        if (\array_key_exists('type', $data)) {
            $object->setType($data['type']);
            unset($data['type']);
        }
        foreach ($data as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_1;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['createdDate'] = $object->getCreatedDate()->format('Y-m-d\\TH:i:sP');
        $data['updatedDate'] = $object->getUpdatedDate()->format('Y-m-d\\TH:i:sP');
        $data['banner'] = $this->normalizer->normalize($object->getBanner(), 'json', $context);
        $data['code'] = $object->getCode();
        $data['legalStructure'] = $this->normalizer->normalize($object->getLegalStructure(), 'json', $context);
        $data['logo'] = $this->normalizer->normalize($object->getLogo(), 'json', $context);
        $data['name'] = $object->getName();
        $values = [];
        foreach ($object->getPictures() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['pictures'] = $values;
        $data['type'] = $object->getType();
        foreach ($object as $key => $value_1) {
            if (\preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_1;
            }
        }

        return $data;
    }

    public function getSupportedTypes(string $format = null): array
    {
        return ['NoahVet\\Reef\\Jane\\Model\\ManufacturerResponseItem' => false];
    }
}
