<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryGroupUserResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string[]
     */
    protected $departments;

    /**
     * @var \DateTime|null
     */
    protected $entryDate;

    /**
     * @var string
     */
    protected $jobTitle;

    /**
     * @var VeterinaryGroupUserResponseItemUser|null
     */
    protected $user;

    /**
     * @var VeterinaryGroupUserResponseItemVeterinaryGroup|null
     */
    protected $veterinaryGroup;

    /**
     * @var \DateTime|null
     */
    protected $exitDate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getDepartments(): array
    {
        return $this->departments;
    }

    /**
     * @param string[] $departments
     */
    public function setDepartments(array $departments): self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;

        return $this;
    }

    public function getEntryDate(): ?\DateTime
    {
        return $this->entryDate;
    }

    public function setEntryDate(?\DateTime $entryDate): self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function setJobTitle(string $jobTitle): self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;

        return $this;
    }

    public function getUser(): ?VeterinaryGroupUserResponseItemUser
    {
        return $this->user;
    }

    public function setUser(?VeterinaryGroupUserResponseItemUser $user): self
    {
        $this->initialized['user'] = true;
        $this->user = $user;

        return $this;
    }

    public function getVeterinaryGroup(): ?VeterinaryGroupUserResponseItemVeterinaryGroup
    {
        return $this->veterinaryGroup;
    }

    public function setVeterinaryGroup(?VeterinaryGroupUserResponseItemVeterinaryGroup $veterinaryGroup): self
    {
        $this->initialized['veterinaryGroup'] = true;
        $this->veterinaryGroup = $veterinaryGroup;

        return $this;
    }

    public function getExitDate(): ?\DateTime
    {
        return $this->exitDate;
    }

    public function setExitDate(?\DateTime $exitDate): self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;

        return $this;
    }
}
