<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryGroupRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $shortDescription;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $logo;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $banner;

    /**
     * @var IdRequest[]|null
     */
    protected $pictures;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $legalNoticeUrl;

    /**
     * @var string|null
     */
    protected $generalConditionUrl;

    /**
     * @var string|null
     */
    protected $privacyPolicyUrl;

    /**
     * @var VeterinaryGroupRequestPostalAddressesItem[]|null
     */
    protected $postalAddresses;

    /**
     * @var string|null
     */
    protected $groupCode;

    /**
     * @var MetadataRequest[]|null
     */
    protected $metadata;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $legalStructure;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $mainBillingAccount;

    /**
     * @var IdRequest[]|null
     */
    protected $creditors;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getShortDescription(): string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getLogo(): ?NullableIdRequest
    {
        return $this->logo;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setLogo(?NullableIdRequest $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getBanner(): ?NullableIdRequest
    {
        return $this->banner;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setBanner(?NullableIdRequest $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    /**
     * @return IdRequest[]|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param IdRequest[]|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getLegalNoticeUrl(): ?string
    {
        return $this->legalNoticeUrl;
    }

    public function setLegalNoticeUrl(?string $legalNoticeUrl): self
    {
        $this->initialized['legalNoticeUrl'] = true;
        $this->legalNoticeUrl = $legalNoticeUrl;

        return $this;
    }

    public function getGeneralConditionUrl(): ?string
    {
        return $this->generalConditionUrl;
    }

    public function setGeneralConditionUrl(?string $generalConditionUrl): self
    {
        $this->initialized['generalConditionUrl'] = true;
        $this->generalConditionUrl = $generalConditionUrl;

        return $this;
    }

    public function getPrivacyPolicyUrl(): ?string
    {
        return $this->privacyPolicyUrl;
    }

    public function setPrivacyPolicyUrl(?string $privacyPolicyUrl): self
    {
        $this->initialized['privacyPolicyUrl'] = true;
        $this->privacyPolicyUrl = $privacyPolicyUrl;

        return $this;
    }

    /**
     * @return VeterinaryGroupRequestPostalAddressesItem[]|null
     */
    public function getPostalAddresses(): ?array
    {
        return $this->postalAddresses;
    }

    /**
     * @param VeterinaryGroupRequestPostalAddressesItem[]|null $postalAddresses
     */
    public function setPostalAddresses(?array $postalAddresses): self
    {
        $this->initialized['postalAddresses'] = true;
        $this->postalAddresses = $postalAddresses;

        return $this;
    }

    public function getGroupCode(): ?string
    {
        return $this->groupCode;
    }

    public function setGroupCode(?string $groupCode): self
    {
        $this->initialized['groupCode'] = true;
        $this->groupCode = $groupCode;

        return $this;
    }

    /**
     * @return MetadataRequest[]|null
     */
    public function getMetadata(): ?array
    {
        return $this->metadata;
    }

    /**
     * @param MetadataRequest[]|null $metadata
     */
    public function setMetadata(?array $metadata): self
    {
        $this->initialized['metadata'] = true;
        $this->metadata = $metadata;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getLegalStructure(): ?NullableIdRequest
    {
        return $this->legalStructure;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setLegalStructure(?NullableIdRequest $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getMainBillingAccount(): ?NullableIdRequest
    {
        return $this->mainBillingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setMainBillingAccount(?NullableIdRequest $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }

    /**
     * @return IdRequest[]|null
     */
    public function getCreditors(): ?array
    {
        return $this->creditors;
    }

    /**
     * @param IdRequest[]|null $creditors
     */
    public function setCreditors(?array $creditors): self
    {
        $this->initialized['creditors'] = true;
        $this->creditors = $creditors;

        return $this;
    }
}
