<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceSubscriptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[]
     */
    protected $attributes;

    /**
     * @var \DateTime
     */
    protected $startDate;

    /**
     * @var \DateTime
     */
    protected $endDate;

    /**
     * @var bool
     */
    protected $isRenewal;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryEstablishment;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryServiceOption;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $billingAccount;

    /**
     * @var string|null
     */
    protected $billingMethod;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param VeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[] $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getStartDate(): \DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(\DateTime $startDate): self
    {
        $this->initialized['startDate'] = true;
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): \DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(\DateTime $endDate): self
    {
        $this->initialized['endDate'] = true;
        $this->endDate = $endDate;

        return $this;
    }

    public function getIsRenewal(): bool
    {
        return $this->isRenewal;
    }

    public function setIsRenewal(bool $isRenewal): self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryEstablishment(): IdRequest
    {
        return $this->veterinaryEstablishment;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryEstablishment(IdRequest $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryServiceOption(): IdRequest
    {
        return $this->veterinaryServiceOption;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryServiceOption(IdRequest $veterinaryServiceOption): self
    {
        $this->initialized['veterinaryServiceOption'] = true;
        $this->veterinaryServiceOption = $veterinaryServiceOption;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getBillingAccount(): ?NullableIdRequest
    {
        return $this->billingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setBillingAccount(?NullableIdRequest $billingAccount): self
    {
        $this->initialized['billingAccount'] = true;
        $this->billingAccount = $billingAccount;

        return $this;
    }

    public function getBillingMethod(): ?string
    {
        return $this->billingMethod;
    }

    public function setBillingMethod(?string $billingMethod): self
    {
        $this->initialized['billingMethod'] = true;
        $this->billingMethod = $billingMethod;

        return $this;
    }
}
