<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class VeterinaryEstablishmentServiceDeliveryResponseItem extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var \DateTime
     */
    protected $completionDate;

    /**
     * @var string|null
     */
    protected $ebpCode;

    /**
     * @var \DateTime
     */
    protected $invoiceDate;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string
     */
    protected $paymentStatus;

    /**
     * @var VeterinaryEstablishmentServiceDeliveryResponseItemServiceDeliveryOption
     */
    protected $serviceDeliveryOption;

    /**
     * @var int
     */
    protected $unitPriceWithoutVat;

    /**
     * @var int
     */
    protected $unitPriceWithVat;

    /**
     * @var int
     */
    protected $vat;

    /**
     * @var VeterinaryEstablishmentServiceDeliveryResponseItemVeterinaryEstablishment
     */
    protected $veterinaryEstablishment;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getCompletionDate(): \DateTime
    {
        return $this->completionDate;
    }

    public function setCompletionDate(\DateTime $completionDate): self
    {
        $this->initialized['completionDate'] = true;
        $this->completionDate = $completionDate;

        return $this;
    }

    public function getEbpCode(): ?string
    {
        return $this->ebpCode;
    }

    public function setEbpCode(?string $ebpCode): self
    {
        $this->initialized['ebpCode'] = true;
        $this->ebpCode = $ebpCode;

        return $this;
    }

    public function getInvoiceDate(): \DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(\DateTime $invoiceDate): self
    {
        $this->initialized['invoiceDate'] = true;
        $this->invoiceDate = $invoiceDate;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getPaymentStatus(): string
    {
        return $this->paymentStatus;
    }

    public function setPaymentStatus(string $paymentStatus): self
    {
        $this->initialized['paymentStatus'] = true;
        $this->paymentStatus = $paymentStatus;

        return $this;
    }

    public function getServiceDeliveryOption(): VeterinaryEstablishmentServiceDeliveryResponseItemServiceDeliveryOption
    {
        return $this->serviceDeliveryOption;
    }

    public function setServiceDeliveryOption(VeterinaryEstablishmentServiceDeliveryResponseItemServiceDeliveryOption $serviceDeliveryOption): self
    {
        $this->initialized['serviceDeliveryOption'] = true;
        $this->serviceDeliveryOption = $serviceDeliveryOption;

        return $this;
    }

    public function getUnitPriceWithoutVat(): int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    public function getUnitPriceWithVat(): int
    {
        return $this->unitPriceWithVat;
    }

    public function setUnitPriceWithVat(int $unitPriceWithVat): self
    {
        $this->initialized['unitPriceWithVat'] = true;
        $this->unitPriceWithVat = $unitPriceWithVat;

        return $this;
    }

    public function getVat(): int
    {
        return $this->vat;
    }

    public function setVat(int $vat): self
    {
        $this->initialized['vat'] = true;
        $this->vat = $vat;

        return $this;
    }

    public function getVeterinaryEstablishment(): VeterinaryEstablishmentServiceDeliveryResponseItemVeterinaryEstablishment
    {
        return $this->veterinaryEstablishment;
    }

    public function setVeterinaryEstablishment(VeterinaryEstablishmentServiceDeliveryResponseItemVeterinaryEstablishment $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }
}
