<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class V1PetPublicProfilesPostBody extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $birthDate;

    /**
     * @var string|null
     */
    protected $freePetBreed;

    /**
     * @var string|null
     */
    protected $gender;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * Id - Common Request Model.
     *
     * @var V1PetPublicProfilesPostBodyPet
     */
    protected $pet;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1PetPublicProfilesPostBodyPetBreed|null
     */
    protected $petBreed;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var V1PetPublicProfilesPostBodyProfilePicture|null
     */
    protected $profilePicture;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getBirthDate(): ?string
    {
        return $this->birthDate;
    }

    public function setBirthDate(?string $birthDate): self
    {
        $this->initialized['birthDate'] = true;
        $this->birthDate = $birthDate;

        return $this;
    }

    public function getFreePetBreed(): ?string
    {
        return $this->freePetBreed;
    }

    public function setFreePetBreed(?string $freePetBreed): self
    {
        $this->initialized['freePetBreed'] = true;
        $this->freePetBreed = $freePetBreed;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->initialized['gender'] = true;
        $this->gender = $gender;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getPet(): V1PetPublicProfilesPostBodyPet
    {
        return $this->pet;
    }

    /**
     * Id - Common Request Model.
     */
    public function setPet(V1PetPublicProfilesPostBodyPet $pet): self
    {
        $this->initialized['pet'] = true;
        $this->pet = $pet;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getPetBreed(): ?V1PetPublicProfilesPostBodyPetBreed
    {
        return $this->petBreed;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setPetBreed(?V1PetPublicProfilesPostBodyPetBreed $petBreed): self
    {
        $this->initialized['petBreed'] = true;
        $this->petBreed = $petBreed;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getProfilePicture(): ?V1PetPublicProfilesPostBodyProfilePicture
    {
        return $this->profilePicture;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setProfilePicture(?V1PetPublicProfilesPostBodyProfilePicture $profilePicture): self
    {
        $this->initialized['profilePicture'] = true;
        $this->profilePicture = $profilePicture;

        return $this;
    }
}
