<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ServiceDeliveryOptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var string
     */
    protected $entitled;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var int
     */
    protected $unitPriceWithoutVat;

    /**
     * Id - Common Request Model.
     *
     * @var IdRequest
     */
    protected $veterinaryService;

    /**
     * @var string|null
     */
    protected $ebpCode;

    /**
     * @var int|null
     */
    protected $vat;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function setCode(string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getDescription(): string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function setEntitled(string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getUnitPriceWithoutVat(): int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    /**
     * Id - Common Request Model.
     */
    public function getVeterinaryService(): IdRequest
    {
        return $this->veterinaryService;
    }

    /**
     * Id - Common Request Model.
     */
    public function setVeterinaryService(IdRequest $veterinaryService): self
    {
        $this->initialized['veterinaryService'] = true;
        $this->veterinaryService = $veterinaryService;

        return $this;
    }

    public function getEbpCode(): ?string
    {
        return $this->ebpCode;
    }

    public function setEbpCode(?string $ebpCode): self
    {
        $this->initialized['ebpCode'] = true;
        $this->ebpCode = $ebpCode;

        return $this;
    }

    public function getVat(): ?int
    {
        return $this->vat;
    }

    public function setVat(?int $vat): self
    {
        $this->initialized['vat'] = true;
        $this->vat = $vat;

        return $this;
    }
}
