<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasVeterinaryEstablishmentServiceSubscriptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var \DateTime
     */
    protected $from;

    /**
     * @var \DateTime
     */
    protected $to;

    /**
     * @var SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[]
     */
    protected $attributes;

    /**
     * @var string
     */
    protected $billingMethod;

    /**
     * @var bool
     */
    protected $isRenewal;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $billingAccount;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getFrom(): \DateTime
    {
        return $this->from;
    }

    public function setFrom(\DateTime $from): self
    {
        $this->initialized['from'] = true;
        $this->from = $from;

        return $this;
    }

    public function getTo(): \DateTime
    {
        return $this->to;
    }

    public function setTo(\DateTime $to): self
    {
        $this->initialized['to'] = true;
        $this->to = $to;

        return $this;
    }

    /**
     * @return SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[]
     */
    public function getAttributes(): array
    {
        return $this->attributes;
    }

    /**
     * @param SchemasVeterinaryEstablishmentServiceSubscriptionRequestAttributesItem[] $attributes
     */
    public function setAttributes(array $attributes): self
    {
        $this->initialized['attributes'] = true;
        $this->attributes = $attributes;

        return $this;
    }

    public function getBillingMethod(): string
    {
        return $this->billingMethod;
    }

    public function setBillingMethod(string $billingMethod): self
    {
        $this->initialized['billingMethod'] = true;
        $this->billingMethod = $billingMethod;

        return $this;
    }

    public function getIsRenewal(): bool
    {
        return $this->isRenewal;
    }

    public function setIsRenewal(bool $isRenewal): self
    {
        $this->initialized['isRenewal'] = true;
        $this->isRenewal = $isRenewal;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getBillingAccount(): ?NullableIdRequest
    {
        return $this->billingAccount;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setBillingAccount(?NullableIdRequest $billingAccount): self
    {
        $this->initialized['billingAccount'] = true;
        $this->billingAccount = $billingAccount;

        return $this;
    }
}
