<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasVeterinaryEstablishmentRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $legalStructure;

    /**
     * @var string|null
     */
    protected $type;

    /**
     * @var string|null
     */
    protected $name;

    /**
     * @var SchemasVeterinaryEstablishmentRequestMainBillingAccount|null
     */
    protected $mainBillingAccount;

    /**
     * @var string|null
     */
    protected $longDescription;

    /**
     * @var string|null
     */
    protected $shortDescription;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $logo;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $banner;

    /**
     * @var IdRequest[]|null
     */
    protected $pictures;

    /**
     * Schedule - Request Model.
     *
     * @var ScheduleRequest|null
     */
    protected $schedule;

    /**
     * @var IdRequest[]|null
     */
    protected $tags;

    /**
     * @var int|null
     */
    protected $entryNumber;

    /**
     * @var string|null
     */
    protected $internalCommentary;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $mainAddress;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getLegalStructure(): ?NullableIdRequest
    {
        return $this->legalStructure;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setLegalStructure(?NullableIdRequest $legalStructure): self
    {
        $this->initialized['legalStructure'] = true;
        $this->legalStructure = $legalStructure;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->initialized['name'] = true;
        $this->name = $name;

        return $this;
    }

    public function getMainBillingAccount(): ?SchemasVeterinaryEstablishmentRequestMainBillingAccount
    {
        return $this->mainBillingAccount;
    }

    public function setMainBillingAccount(?SchemasVeterinaryEstablishmentRequestMainBillingAccount $mainBillingAccount): self
    {
        $this->initialized['mainBillingAccount'] = true;
        $this->mainBillingAccount = $mainBillingAccount;

        return $this;
    }

    public function getLongDescription(): ?string
    {
        return $this->longDescription;
    }

    public function setLongDescription(?string $longDescription): self
    {
        $this->initialized['longDescription'] = true;
        $this->longDescription = $longDescription;

        return $this;
    }

    public function getShortDescription(): ?string
    {
        return $this->shortDescription;
    }

    public function setShortDescription(?string $shortDescription): self
    {
        $this->initialized['shortDescription'] = true;
        $this->shortDescription = $shortDescription;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getLogo(): ?NullableIdRequest
    {
        return $this->logo;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setLogo(?NullableIdRequest $logo): self
    {
        $this->initialized['logo'] = true;
        $this->logo = $logo;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getBanner(): ?NullableIdRequest
    {
        return $this->banner;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setBanner(?NullableIdRequest $banner): self
    {
        $this->initialized['banner'] = true;
        $this->banner = $banner;

        return $this;
    }

    /**
     * @return IdRequest[]|null
     */
    public function getPictures(): ?array
    {
        return $this->pictures;
    }

    /**
     * @param IdRequest[]|null $pictures
     */
    public function setPictures(?array $pictures): self
    {
        $this->initialized['pictures'] = true;
        $this->pictures = $pictures;

        return $this;
    }

    /**
     * Schedule - Request Model.
     */
    public function getSchedule(): ?ScheduleRequest
    {
        return $this->schedule;
    }

    /**
     * Schedule - Request Model.
     */
    public function setSchedule(?ScheduleRequest $schedule): self
    {
        $this->initialized['schedule'] = true;
        $this->schedule = $schedule;

        return $this;
    }

    /**
     * @return IdRequest[]|null
     */
    public function getTags(): ?array
    {
        return $this->tags;
    }

    /**
     * @param IdRequest[]|null $tags
     */
    public function setTags(?array $tags): self
    {
        $this->initialized['tags'] = true;
        $this->tags = $tags;

        return $this;
    }

    public function getEntryNumber(): ?int
    {
        return $this->entryNumber;
    }

    public function setEntryNumber(?int $entryNumber): self
    {
        $this->initialized['entryNumber'] = true;
        $this->entryNumber = $entryNumber;

        return $this;
    }

    public function getInternalCommentary(): ?string
    {
        return $this->internalCommentary;
    }

    public function setInternalCommentary(?string $internalCommentary): self
    {
        $this->initialized['internalCommentary'] = true;
        $this->internalCommentary = $internalCommentary;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getMainAddress(): ?NullableIdRequest
    {
        return $this->mainAddress;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setMainAddress(?NullableIdRequest $mainAddress): self
    {
        $this->initialized['mainAddress'] = true;
        $this->mainAddress = $mainAddress;

        return $this;
    }
}
