<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class SchemasServiceDeliveryOptionRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string|null
     */
    protected $code;

    /**
     * @var string|null
     */
    protected $description;

    /**
     * @var string|null
     */
    protected $ebpCode;

    /**
     * @var string|null
     */
    protected $entitled;

    /**
     * @var string|null
     */
    protected $type;

    /**
     * @var int|null
     */
    protected $unitPriceWithoutVat;

    /**
     * @var int|null
     */
    protected $vat;

    /**
     * Nullable Id - Common Request Model.
     *
     * @var NullableIdRequest|null
     */
    protected $veterinaryService;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): self
    {
        $this->initialized['code'] = true;
        $this->code = $code;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->initialized['description'] = true;
        $this->description = $description;

        return $this;
    }

    public function getEbpCode(): ?string
    {
        return $this->ebpCode;
    }

    public function setEbpCode(?string $ebpCode): self
    {
        $this->initialized['ebpCode'] = true;
        $this->ebpCode = $ebpCode;

        return $this;
    }

    public function getEntitled(): ?string
    {
        return $this->entitled;
    }

    public function setEntitled(?string $entitled): self
    {
        $this->initialized['entitled'] = true;
        $this->entitled = $entitled;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->initialized['type'] = true;
        $this->type = $type;

        return $this;
    }

    public function getUnitPriceWithoutVat(): ?int
    {
        return $this->unitPriceWithoutVat;
    }

    public function setUnitPriceWithoutVat(?int $unitPriceWithoutVat): self
    {
        $this->initialized['unitPriceWithoutVat'] = true;
        $this->unitPriceWithoutVat = $unitPriceWithoutVat;

        return $this;
    }

    public function getVat(): ?int
    {
        return $this->vat;
    }

    public function setVat(?int $vat): self
    {
        $this->initialized['vat'] = true;
        $this->vat = $vat;

        return $this;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function getVeterinaryService(): ?NullableIdRequest
    {
        return $this->veterinaryService;
    }

    /**
     * Nullable Id - Common Request Model.
     */
    public function setVeterinaryService(?NullableIdRequest $veterinaryService): self
    {
        $this->initialized['veterinaryService'] = true;
        $this->veterinaryService = $veterinaryService;

        return $this;
    }
}
