<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ScheduleRequest extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $monday;

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $tuesday;

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $wednesday;

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $thursday;

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $friday;

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $saturday;

    /**
     * @var OpeningPeriodRequest[]|null
     */
    protected $sunday;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getMonday(): ?array
    {
        return $this->monday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $monday
     */
    public function setMonday(?array $monday): self
    {
        $this->initialized['monday'] = true;
        $this->monday = $monday;

        return $this;
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getTuesday(): ?array
    {
        return $this->tuesday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $tuesday
     */
    public function setTuesday(?array $tuesday): self
    {
        $this->initialized['tuesday'] = true;
        $this->tuesday = $tuesday;

        return $this;
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getWednesday(): ?array
    {
        return $this->wednesday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $wednesday
     */
    public function setWednesday(?array $wednesday): self
    {
        $this->initialized['wednesday'] = true;
        $this->wednesday = $wednesday;

        return $this;
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getThursday(): ?array
    {
        return $this->thursday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $thursday
     */
    public function setThursday(?array $thursday): self
    {
        $this->initialized['thursday'] = true;
        $this->thursday = $thursday;

        return $this;
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getFriday(): ?array
    {
        return $this->friday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $friday
     */
    public function setFriday(?array $friday): self
    {
        $this->initialized['friday'] = true;
        $this->friday = $friday;

        return $this;
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getSaturday(): ?array
    {
        return $this->saturday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $saturday
     */
    public function setSaturday(?array $saturday): self
    {
        $this->initialized['saturday'] = true;
        $this->saturday = $saturday;

        return $this;
    }

    /**
     * @return OpeningPeriodRequest[]|null
     */
    public function getSunday(): ?array
    {
        return $this->sunday;
    }

    /**
     * @param OpeningPeriodRequest[]|null $sunday
     */
    public function setSunday(?array $sunday): self
    {
        $this->initialized['sunday'] = true;
        $this->sunday = $sunday;

        return $this;
    }
}
