<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class OpeningPeriodResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * Opening Hour - Common Response Model.
     *
     * @var OpeningHourResponse
     */
    protected $start;

    /**
     * Opening Hour - Common Response Model.
     *
     * @var OpeningHourResponse
     */
    protected $end;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    /**
     * Opening Hour - Common Response Model.
     */
    public function getStart(): OpeningHourResponse
    {
        return $this->start;
    }

    /**
     * Opening Hour - Common Response Model.
     */
    public function setStart(OpeningHourResponse $start): self
    {
        $this->initialized['start'] = true;
        $this->start = $start;

        return $this;
    }

    /**
     * Opening Hour - Common Response Model.
     */
    public function getEnd(): OpeningHourResponse
    {
        return $this->end;
    }

    /**
     * Opening Hour - Common Response Model.
     */
    public function setEnd(OpeningHourResponse $end): self
    {
        $this->initialized['end'] = true;
        $this->end = $end;

        return $this;
    }
}
