<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Model;

class ComponentsSchemasVeterinaryEstablishmentUserResponse extends \ArrayObject
{
    /**
     * @var array
     */
    protected $initialized = [];

    /**
     * @var string
     */
    protected $id;

    /**
     * @var \DateTime
     */
    protected $createdDate;

    /**
     * @var \DateTime
     */
    protected $updatedDate;

    /**
     * @var string
     */
    protected $jobTitle;

    /**
     * @var string[]
     */
    protected $departments;

    /**
     * @var ComponentsSchemasVeterinaryEstablishmentUserResponseUser
     */
    protected $user;

    /**
     * @var ComponentsSchemasVeterinaryEstablishmentUserResponseVeterinaryEstablishment
     */
    protected $veterinaryEstablishment;

    /**
     * @var \DateTime
     */
    protected $entryDate;

    /**
     * @var \DateTime|null
     */
    protected $exitDate;

    public function isInitialized($property): bool
    {
        return \array_key_exists($property, $this->initialized);
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->initialized['id'] = true;
        $this->id = $id;

        return $this;
    }

    public function getCreatedDate(): \DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(\DateTime $createdDate): self
    {
        $this->initialized['createdDate'] = true;
        $this->createdDate = $createdDate;

        return $this;
    }

    public function getUpdatedDate(): \DateTime
    {
        return $this->updatedDate;
    }

    public function setUpdatedDate(\DateTime $updatedDate): self
    {
        $this->initialized['updatedDate'] = true;
        $this->updatedDate = $updatedDate;

        return $this;
    }

    public function getJobTitle(): string
    {
        return $this->jobTitle;
    }

    public function setJobTitle(string $jobTitle): self
    {
        $this->initialized['jobTitle'] = true;
        $this->jobTitle = $jobTitle;

        return $this;
    }

    /**
     * @return string[]
     */
    public function getDepartments(): array
    {
        return $this->departments;
    }

    /**
     * @param string[] $departments
     */
    public function setDepartments(array $departments): self
    {
        $this->initialized['departments'] = true;
        $this->departments = $departments;

        return $this;
    }

    public function getUser(): ComponentsSchemasVeterinaryEstablishmentUserResponseUser
    {
        return $this->user;
    }

    public function setUser(ComponentsSchemasVeterinaryEstablishmentUserResponseUser $user): self
    {
        $this->initialized['user'] = true;
        $this->user = $user;

        return $this;
    }

    public function getVeterinaryEstablishment(): ComponentsSchemasVeterinaryEstablishmentUserResponseVeterinaryEstablishment
    {
        return $this->veterinaryEstablishment;
    }

    public function setVeterinaryEstablishment(ComponentsSchemasVeterinaryEstablishmentUserResponseVeterinaryEstablishment $veterinaryEstablishment): self
    {
        $this->initialized['veterinaryEstablishment'] = true;
        $this->veterinaryEstablishment = $veterinaryEstablishment;

        return $this;
    }

    public function getEntryDate(): \DateTime
    {
        return $this->entryDate;
    }

    public function setEntryDate(\DateTime $entryDate): self
    {
        $this->initialized['entryDate'] = true;
        $this->entryDate = $entryDate;

        return $this;
    }

    public function getExitDate(): ?\DateTime
    {
        return $this->exitDate;
    }

    public function setExitDate(?\DateTime $exitDate): self
    {
        $this->initialized['exitDate'] = true;
        $this->exitDate = $exitDate;

        return $this;
    }
}
