<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetAssetsABC extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    protected $a;

    protected $b;

    protected $c;

    /**
     * Get AssetsABC.
     *
     * @param string $a the dynamic name
     * @param string $b the dynamic name
     * @param string $c the dynamic name
     */
    public function __construct(string $a, string $b, string $c)
    {
        $this->a = $a;
        $this->b = $b;
        $this->c = $c;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return \str_replace(['{a}', '{b}', '{c}'], [$this->a, $this->b, $this->c], '/assets/{a}/{b}/{c}');
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    /**
     * @return null
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABCBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\GetAssetsABCNotFoundException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (200 === $status) {
            return null;
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAssetsABCBadRequestException($response);
        }
        if (404 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAssetsABCNotFoundException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
