<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetAllVeterinaryGroupUser extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * List Veterinary Group Users.
     * A Veterinary Group User s a member of the Veterinary Group.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary group department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromEntryDate[] Filter from entryDate
     * @var array  $fromExitDate[] Filter from exitDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toEntryDate[] Filter to entryDate
     * @var array  $toExitDate[] Filter to exitDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntryDate sort by entryDate
     * @var string $sortExitDate sort by exitDate
     * @var string $sortJobTitle Sort by jobTitle.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/v1/veterinary_group_users';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'department', 'jobTitle', 'userId', 'veterinaryGroupId', 'veterinaryServiceOptionId', 'fromCreatedDate', 'fromUpdatedDate', 'fromEntryDate', 'fromExitDate', 'toCreatedDate', 'toUpdatedDate', 'toEntryDate', 'toExitDate', 'sortCreatedDate', 'sortUpdatedDate', 'sortEntryDate', 'sortExitDate', 'sortJobTitle']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('department', ['array']);
        $optionsResolver->addAllowedTypes('jobTitle', ['array']);
        $optionsResolver->addAllowedTypes('userId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryGroupId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryServiceOptionId', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('fromEntryDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('fromExitDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toEntryDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toExitDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortEntryDate', ['string']);
        $optionsResolver->addAllowedTypes('sortExitDate', ['string']);
        $optionsResolver->addAllowedTypes('sortJobTitle', ['string']);

        return $optionsResolver;
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseItem[]
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryGroupUserBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItem[]', 'json');
        }
        if ((null === $contentType) === false && (206 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryGroupUserResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAllVeterinaryGroupUserBadRequestException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
