<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetAllVeterinaryEstablishmentServiceDelivery extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * List Veterinary Establishment Service Deliveries.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $serviceDeliveryOptionType[] Filter by serviceDeliveryOptionType
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortCode sort by code
     * @var string $sortCompletionDate sort by completionDate
     * @var string $sortEbpCode sort by EbpCode
     * @var string $sortInvoiceDate sort by invoiceDate
     * @var string $sortPaymentStatus sort by paymentStatus
     * @var string $sortUnitPriceWithoutVat sort by unitPriceWithoutVat
     * @var string $sortUnitPriceWithVat sort by unitPriceWithVat
     * @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/v1/veterinary_establishment_service_deliveries';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'id', 'veterinaryServiceId', 'veterinaryEstablishmentId', 'serviceDeliveryOptionType', 'fromCreatedDate', 'fromUpdatedDate', 'toCreatedDate', 'toUpdatedDate', 'sortCreatedDate', 'sortUpdatedDate', 'sortCode', 'sortCompletionDate', 'sortEbpCode', 'sortInvoiceDate', 'sortPaymentStatus', 'sortUnitPriceWithoutVat', 'sortUnitPriceWithVat', 'sortVeterinaryServiceEntitled']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryServiceId', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentId', ['array']);
        $optionsResolver->addAllowedTypes('serviceDeliveryOptionType', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortCode', ['string']);
        $optionsResolver->addAllowedTypes('sortCompletionDate', ['string']);
        $optionsResolver->addAllowedTypes('sortEbpCode', ['string']);
        $optionsResolver->addAllowedTypes('sortInvoiceDate', ['string']);
        $optionsResolver->addAllowedTypes('sortPaymentStatus', ['string']);
        $optionsResolver->addAllowedTypes('sortUnitPriceWithoutVat', ['string']);
        $optionsResolver->addAllowedTypes('sortUnitPriceWithVat', ['string']);
        $optionsResolver->addAllowedTypes('sortVeterinaryServiceEntitled', ['string']);

        return $optionsResolver;
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryResponseItem[]
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponseItem[]', 'json');
        }
        if ((null === $contentType) === false && (206 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentServiceDeliveryResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentServiceDeliveryBadRequestException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
