<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane\Endpoint;

class GetAllVeterinaryEstablishment extends \NoahVet\Reef\Jane\Runtime\Client\BaseEndpoint implements \NoahVet\Reef\Jane\Runtime\Client\Endpoint
{
    use \NoahVet\Reef\Jane\Runtime\Client\EndpointTrait;

    /**
     * List Veterinary Establishments.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $veuJobTitle[] Filter by jobTitle of veterinary establishment user
     * @var array  $id[] Filter by id
     * @var array  $veuUserId[] Filter by userId of Veterinary Establishment User
     * @var array  $name[] Filter by name
     * @var array  $privilegedCode[] Filter by privilegedCode
     * @var array  $type[] Filter by type
     * @var array  $tag[] Filter by tag
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortName sort by name
     * @var string $sortPrivilegedCode sort by privilegedCode
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     */
    public function __construct(array $queryParameters = [], array $headerParameters = [])
    {
        $this->queryParameters = $queryParameters;
        $this->headerParameters = $headerParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/v1/veterinary_establishments';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page', 'limit', 'veuJobTitle', 'id', 'veuUserId', 'name', 'privilegedCode', 'type', 'tag', 'veterinaryEstablishmentMemberId', 'fromCreatedDate', 'fromUpdatedDate', 'toCreatedDate', 'toUpdatedDate', 'sortCreatedDate', 'sortEntryNumber', 'sortName', 'sortPrivilegedCode', 'sortType', 'sortUpdatedDate']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);
        $optionsResolver->addAllowedTypes('limit', ['int']);
        $optionsResolver->addAllowedTypes('veuJobTitle', ['array']);
        $optionsResolver->addAllowedTypes('id', ['array']);
        $optionsResolver->addAllowedTypes('veuUserId', ['array']);
        $optionsResolver->addAllowedTypes('name', ['array']);
        $optionsResolver->addAllowedTypes('privilegedCode', ['array']);
        $optionsResolver->addAllowedTypes('type', ['array']);
        $optionsResolver->addAllowedTypes('tag', ['array']);
        $optionsResolver->addAllowedTypes('veterinaryEstablishmentMemberId', ['array']);
        $optionsResolver->addAllowedTypes('fromCreatedDate', ['array']);
        $optionsResolver->addAllowedTypes('fromUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toCreatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('toUpdatedDate', ['array', 'null']);
        $optionsResolver->addAllowedTypes('sortCreatedDate', ['string']);
        $optionsResolver->addAllowedTypes('sortEntryNumber', ['string']);
        $optionsResolver->addAllowedTypes('sortName', ['string']);
        $optionsResolver->addAllowedTypes('sortPrivilegedCode', ['string']);
        $optionsResolver->addAllowedTypes('sortType', ['string']);
        $optionsResolver->addAllowedTypes('sortUpdatedDate', ['string']);

        return $optionsResolver;
    }

    protected function getHeadersOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getHeadersOptionsResolver();
        $optionsResolver->setDefined(['Accept-Language']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('Accept-Language', ['string']);

        return $optionsResolver;
    }

    /**
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponseItem[]
     *
     * @throws \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentBadRequestException
     * @throws \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if ((null === $contentType) === false && (200 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponseItem[]', 'json');
        }
        if ((null === $contentType) === false && (206 === $status && false !== \mb_strpos($contentType, 'application/json'))) {
            return $serializer->deserialize($body, 'NoahVet\\Reef\\Jane\\Model\\VeterinaryEstablishmentResponseItem[]', 'json');
        }
        if (400 === $status) {
            throw new \NoahVet\Reef\Jane\Exception\GetAllVeterinaryEstablishmentBadRequestException($response);
        }
        throw new \NoahVet\Reef\Jane\Exception\UnexpectedStatusCodeException($status, $body);
    }
}
