<?php

declare(strict_types=1);

namespace NoahVet\Reef\Jane;

class Client extends Runtime\Client\Client
{
    /**
     * Get AssetsA.
     *
     * @param string $a     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\GetAssetsABadRequestException
     * @throws Exception\GetAssetsANotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAssetsA(string $a, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAssetsA($a), $fetch);
    }

    /**
     * Get AssetsAB.
     *
     * @param string $a     the dynamic name
     * @param string $b     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\GetAssetsABBadRequestException
     * @throws Exception\GetAssetsABNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAssetsAB(string $a, string $b, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAssetsAB($a, $b), $fetch);
    }

    /**
     * Get AssetsABC.
     *
     * @param string $a     the dynamic name
     * @param string $b     the dynamic name
     * @param string $c     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\GetAssetsABCBadRequestException
     * @throws Exception\GetAssetsABCNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAssetsABC(string $a, string $b, string $c, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAssetsABC($a, $b, $c), $fetch);
    }

    /**
     * Get AssetsABCD.
     *
     * @param string $a     the dynamic name
     * @param string $b     the dynamic name
     * @param string $c     the dynamic name
     * @param string $d     the dynamic name
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\GetAssetsABCDBadRequestException
     * @throws Exception\GetAssetsABCDNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAssetsABCD(string $a, string $b, string $c, string $d, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAssetsABCD($a, $b, $c, $d), $fetch);
    }

    /**
     * List Billing Accounts.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $legalStructureId[] Filter by legalStructureId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\BillingAccountResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllBillingAccountBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllBillingAccount(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllBillingAccount($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Billing Account.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasBillingAccountResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostBillingAccountBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postBillingAccount(Model\BillingAccountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostBillingAccount($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Billing Account by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasBillingAccountResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneBillingAccountBadRequestException
     * @throws Exception\UpdateOneBillingAccountNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneBillingAccount(string $id, Model\SchemasBillingAccountRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneBillingAccount($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Mandates.
     * A Mandate is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $prefix[] Filter by prefix
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\MandateResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllMandateBadRequestException
     * @throws Exception\GetAllMandateInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllMandate(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllMandate($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Get a Mandate by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept language for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasMandateResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetOneMandateBadRequestException
     * @throws Exception\GetOneMandateNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneMandate($id, $headerParameters), $fetch);
    }

    /**
     * Get an image preview of Required Mandate by Billing Account Id.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept language for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\GetOneImagePreviewRequiredMandateBadRequestException
     * @throws Exception\GetOneImagePreviewRequiredMandateNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneImagePreviewRequiredMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneImagePreviewRequiredMandate($id, $headerParameters), $fetch);
    }

    /**
     * Get a Yousign Signature Request by Legal Structure Id.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept language for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\YousignSignatureRequestResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetOneYousignSignatureRequestBadRequestException
     * @throws Exception\GetOneYousignSignatureRequestNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneYousignSignatureRequest(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneYousignSignatureRequest($id, $headerParameters), $fetch);
    }

    /**
     * List Required Mandates.
     * A Required Mandate is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $billingAccountId[] Filter by billingAccountId
     * @var array  $mandateId[] Filter by mandateId
     * @var bool   $isValidated Filter by validated / not validated
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\RequiredMandateResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllRequiredMandateBadRequestException
     * @throws Exception\GetAllRequiredMandateInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllRequiredMandate(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllRequiredMandate($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Required Mandate.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasRequiredMandateResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostRequiredMandateBadRequestException
     * @throws Exception\PostRequiredMandateInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postRequiredMandate(Model\RequiredMandateRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostRequiredMandate($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Required Mandate.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneRequiredMandateBadRequestException
     * @throws Exception\DeleteOneRequiredMandateNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneRequiredMandate(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneRequiredMandate($id, $headerParameters), $fetch);
    }

    /**
     * Confirma a Yousign Signature Request by Legal Structure Id.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept language for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\GetOneYousignSignatureRequestConfirmationBadRequestException
     * @throws Exception\GetOneYousignSignatureRequestConfirmationNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneYousignSignatureRequestConfirmation(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneYousignSignatureRequestConfirmation($id, $headerParameters), $fetch);
    }

    /**
     * List Invitations.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $hostUserId[] Filter by hostUserId
     * @var array  $invitedUserId[] Filter by invitedUserId
     * @var array  $status[] Filter by status
     * @var array  $type[] Filter by type
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromExpirationDate[] Filter from expirationDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toExpirationDate[] Filter to expirationDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortExpirationDate Sort by expirationDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\InvitationResponse[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllInvitationBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllInvitation(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllInvitation($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Send a new email invitation.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept the request accept language for content negotiation
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\RemindInvitationNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function remindInvitation(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\RemindInvitation($id, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment User Invitation.
     * A Veterinary Establishment User Invitations is an invitation to join a veterinary establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentUserInvitationBadRequestException
     * @throws Exception\PostVeterinaryEstablishmentUserInvitationConflictException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentUserInvitation(Model\VeterinaryEstablishmentUserInvitationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentUserInvitation($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment User Invitation Confirmation.
     * A Veterinary Establishment User Invitation Confirmation is an confirmation to join or not a veterinary establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserInvitationConfirmationResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentUserInvitationConfirmationBadRequestException
     * @throws Exception\PostVeterinaryEstablishmentUserInvitationConfirmationNotFoundException
     * @throws Exception\PostVeterinaryEstablishmentUserInvitationConfirmationGoneException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentUserInvitationConfirmation(Model\VeterinaryEstablishmentUserInvitationConfirmationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentUserInvitationConfirmation($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group User Invitation.
     * A Veterinary Group User Invitations is an invitation to join a veterinary group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryGroupUserInvitationBadRequestException
     * @throws Exception\PostVeterinaryGroupUserInvitationConflictException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroupUserInvitation(Model\VeterinaryGroupUserInvitationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryGroupUserInvitation($requestBody, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group User Invitation Confirmation.
     * A Veterinary Group User Invitation Confirmation is an confirmation to join or not a veterinary group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryGroupUserInvitationConfirmationResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryGroupUserInvitationConfirmationBadRequestException
     * @throws Exception\PostVeterinaryGroupUserInvitationConfirmationNotFoundException
     * @throws Exception\PostVeterinaryGroupUserInvitationConfirmationGoneException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroupUserInvitationConfirmation(Model\VeterinaryGroupUserInvitationConfirmationRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryGroupUserInvitationConfirmation($requestBody, $headerParameters), $fetch);
    }

    /**
     * List Legal Structures.
     * A legal structure is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\LegalStructureResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllLegalStructureBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllLegalStructure(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllLegalStructure($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Legal Structure.
     *
     * A legal structure is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasLegalStructureResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostLegalStructureBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postLegalStructure(Model\LegalStructureRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostLegalStructure($requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Legal Structure by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasLegalStructureResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetOneLegalStructureBadRequestException
     * @throws Exception\GetOneLegalStructureNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneLegalStructure(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneLegalStructure($id, $headerParameters), $fetch);
    }

    /**
     * Update a Legal Structure by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasLegalStructureResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneLegalStructureBadRequestException
     * @throws Exception\UpdateOneLegalStructureNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneLegalStructure(string $id, Model\SchemasLegalStructureRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneLegalStructure($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Search on Legal Structures.
     * A legal structure is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\LegalStructureResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\SearchLegalStructureBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function searchLegalStructure(Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\SearchLegalStructure($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Manufacturers.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $code[] Filter by code
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ManufacturerResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllManufacturerBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllManufacturer(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllManufacturer($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Documents.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\DocumentResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllDocumentsBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllDocuments(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllDocuments($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Document. A Document represents pdf file.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasDocumentResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostDocumentBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postDocument(Model\DocumentRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostDocument($requestBody, $headerParameters), $fetch);
    }

    /**
     * List Images.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ImageResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllImagesBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllImages(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllImages($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Image. A Image represents gif, jpeg or png file.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasImageResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostImageBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postImage(Model\ImageRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostImage($requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Service Deliveries.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $serviceDeliveryOptionType[] Filter by serviceDeliveryOptionType
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortCode sort by code
     * @var string $sortCompletionDate sort by completionDate
     * @var string $sortEbpCode sort by EbpCode
     * @var string $sortInvoiceDate sort by invoiceDate
     * @var string $sortPaymentStatus sort by paymentStatus
     * @var string $sortUnitPriceWithoutVat sort by unitPriceWithoutVat
     * @var string $sortUnitPriceWithVat sort by unitPriceWithVat
     * @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceDeliveryResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentServiceDelivery(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentServiceDelivery($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a VeterinaryEstablishmentServiceDelivery.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentServiceDelivery(Model\VeterinaryEstablishmentServiceDeliveryRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentServiceDelivery($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Service Delivery.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws Exception\DeleteOneVeterinaryEstablishmentServiceDeliveryNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentServiceDelivery(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneVeterinaryEstablishmentServiceDelivery($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Service Delivery by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceDeliveryResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryBadRequestException
     * @throws Exception\UpdateOneVeterinaryEstablishmentServiceDeliveryNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentServiceDelivery(string $id, Model\SchemasVeterinaryEstablishmentServiceDeliveryRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryEstablishmentServiceDelivery($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Service Delivery Options.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $type[] Filter by type
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEbpCode sort by EbpCode
     * @var string $sortEntitled sort by Entitled
     * @var string $sortType sort by type
     * @var string $sortUnitPriceWithoutVat sort by unitPriceWithoutVat
     * @var string $sortUnitPriceWithVat sort by unitPriceWithVat
     * @var string $sortVeterinaryServiceEntitled Sort by veterinaryServiceEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ServiceDeliveryOptionResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllServiceDeliveryOptionBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllServiceDeliveryOption(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllServiceDeliveryOption($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a ServiceDeliveryOption.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasServiceDeliveryOptionResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostServiceDeliveryOptionBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postServiceDeliveryOption(Model\ServiceDeliveryOptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostServiceDeliveryOption($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Service Delivery Option.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneServiceDeliveryOptionBadRequestException
     * @throws Exception\DeleteOneServiceDeliveryOptionNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneServiceDeliveryOption(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneServiceDeliveryOption($id, $headerParameters), $fetch);
    }

    /**
     * Update a Service Delivery Option by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasServiceDeliveryOptionResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneServiceDeliveryOptionBadRequestException
     * @throws Exception\UpdateOneServiceDeliveryOptionNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneServiceDeliveryOption(string $id, Model\SchemasServiceDeliveryOptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneServiceDeliveryOption($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Manufacturer Users.
     * A Manufacturer User s a member of the Manufacturer.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary establishment department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $manufacturerId[] Filter by manufacturerId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ManufacturerUserResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllManufacturerUserBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllManufacturerUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllManufacturerUser($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Users.
     * A Veterinary Establishment User s a member of the Veterinary Establishment.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary establishment department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromEntryDate[] Filter from entryDate
     * @var array  $fromExitDate[] Filter from exitDate
     * @var array  $fromServicePeriodStartDate[] Filter from servicePeriodStartDate
     * @var array  $fromServicePeriodEndDate[] Filter from servicePeriodEndDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toEntryDate[] Filter to entryDate
     * @var array  $toExitDate[] Filter to exitDate
     * @var array  $toServicePeriodStartDate[] Filter to servicePeriodStartDate
     * @var array  $toServicePeriodEndDate[] Filter to servicePeriodEndDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntryDate sort by entryDate
     * @var string $sortExitDate sort by exitDate
     * @var string $sortJobTitle Sort by jobTitle.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentUserResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentUserBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentUser($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment User.
     * A Veterinary Establishment User is a member of the Veterinary Establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentUserResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentUserBadRequestException
     * @throws Exception\PostVeterinaryEstablishmentUserConflictException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentUser(Model\VeterinaryEstablishmentUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentUser($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment User.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneVeterinaryEstablishmentUserBadRequestException
     * @throws Exception\DeleteOneVeterinaryEstablishmentUserNotFoundException
     * @throws Exception\DeleteOneVeterinaryEstablishmentUserGoneException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentUser(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneVeterinaryEstablishmentUser($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment User by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentUserResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryEstablishmentUserBadRequestException
     * @throws Exception\UpdateOneVeterinaryEstablishmentUserNotFoundException
     * @throws Exception\UpdateOneVeterinaryEstablishmentUserGoneException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentUser(string $id, Model\SchemasVeterinaryEstablishmentUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryEstablishmentUser($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Group Users.
     * A Veterinary Group User s a member of the Veterinary Group.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $department[] Filter by veterinary group department
     * @var array  $jobTitle[] Filter by jobTitle
     * @var array  $userId[] Filter by userId
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromEntryDate[] Filter from entryDate
     * @var array  $fromExitDate[] Filter from exitDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toEntryDate[] Filter to entryDate
     * @var array  $toExitDate[] Filter to exitDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntryDate sort by entryDate
     * @var string $sortExitDate sort by exitDate
     * @var string $sortJobTitle Sort by jobTitle.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryGroupUserResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryGroupUserBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryGroupUser(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryGroupUser($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group User.
     * A Veterinary Group User s a member of the Veterinary Group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupUserResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryGroupUserBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroupUser(Model\VeterinaryGroupUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryGroupUser($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Group User.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneVeterinaryGroupUserBadRequestException
     * @throws Exception\DeleteOneVeterinaryGroupUserNotFoundException
     * @throws Exception\DeleteOneVeterinaryGroupUserGoneException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryGroupUser(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneVeterinaryGroupUser($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Group User by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryGroupUserResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryGroupUserBadRequestException
     * @throws Exception\UpdateOneVeterinaryGroupUserNotFoundException
     * @throws Exception\UpdateOneVeterinaryGroupUserGoneException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryGroupUser(string $id, Model\SchemasVeterinaryGroupUserRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryGroupUser($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishments.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $veuJobTitle[] Filter by jobTitle of veterinary establishment user
     * @var array  $id[] Filter by id
     * @var array  $veuUserId[] Filter by userId of Veterinary Establishment User
     * @var array  $name[] Filter by name
     * @var array  $privilegedCode[] Filter by privilegedCode
     * @var array  $type[] Filter by type
     * @var array  $tag[] Filter by tag
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortName sort by name
     * @var string $sortPrivilegedCode sort by privilegedCode
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishment(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishment($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment.
     * This endpoint will also create a Veterinary Establishment.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishment(Model\VeterinaryEstablishmentRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishment($requestBody, $headerParameters), $fetch);
    }

    /**
     * Export Veterinary Establishments.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\ExportVeterinaryEstablishmentBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function exportVeterinaryEstablishment(array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\ExportVeterinaryEstablishment($headerParameters), $fetch);
    }

    /**
     * Get a Veterinary Establishment by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetOneVeterinaryEstablishmentBadRequestException
     * @throws Exception\GetOneVeterinaryEstablishmentNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneVeterinaryEstablishment(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneVeterinaryEstablishment($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponseComponentsSchemasVeterinaryEstablishmentResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryEstablishmentBadRequestException
     * @throws Exception\UpdateOneVeterinaryEstablishmentNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishment(string $id, Model\SchemasVeterinaryEstablishmentRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryEstablishment($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Search on Veterinary Establishments.
     * A veterinary establishment is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $name[] Filter by name
     * @var array  $privilegedCode[] Filter by privilegedCode
     * @var array  $type[] Filter by type
     * @var array  $tag[] Filter by tag
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortName sort by name
     * @var string $sortPrivilegedCode sort by privilegedCode
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\SearchVeterinaryEstablishmentBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function searchVeterinaryEstablishment(Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\SearchVeterinaryEstablishment($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Address.
     * This endpoint will create a Veterinary Establishment Address and add it in the Veterinary Establishment Address list.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentAddressBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentAddress(Model\VeterinaryEstablishmentAddressRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentAddress($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Address.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneVeterinaryEstablishmentAddressBadRequestException
     * @throws Exception\DeleteOneVeterinaryEstablishmentAddressNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentAddress(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneVeterinaryEstablishmentAddress($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Address by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentAddressResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryEstablishmentAddressBadRequestException
     * @throws Exception\UpdateOneVeterinaryEstablishmentAddressNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentAddress(string $id, Model\SchemasVeterinaryEstablishmentAddressRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryEstablishmentAddress($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Credit Notes.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $moderationUserId[] Filter by moderationUserId
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $documentCode[] Filter by documentCode
     * @var array  $accountingStatus[] Filter by accountingStatus
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentCreditNoteResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentCreditNote(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentCreditNote($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Credit Note.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentCreditNote(Model\VeterinaryEstablishmentCreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentCreditNote($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Credit Note by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentCreditNoteResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws Exception\UpdateOneVeterinaryEstablishmentCreditNoteNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentCreditNote(string $id, Model\SchemasVeterinaryEstablishmentCreditNoteRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryEstablishmentCreditNote($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a lot of Veterinary Establishment Credit Note.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\UpdateVeterinaryEstablishmentCreditNoteBulkBadRequestException
     * @throws Exception\UpdateVeterinaryEstablishmentCreditNoteBulkNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateVeterinaryEstablishmentCreditNoteBulk(Model\VeterinaryEstablishmentCreditNoteBulkRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateVeterinaryEstablishmentCreditNoteBulk($requestBody, $headerParameters), $fetch);
    }

    /**
     * Export Veterinary Establishment Credit Notes.
     *
     * @param array $queryParameters {
     *
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $moderationUserId[] Filter by moderationUserId
     * @var array  $accountingStatus[] Filter by accountingStatus
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\ExportVeterinaryEstablishmentCreditNoteBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function exportVeterinaryEstablishmentCreditNote(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\ExportVeterinaryEstablishmentCreditNote($queryParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Members.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName
     * @var array  $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentMemberBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentMember(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentMember($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Member.
     * A Veterinary Establishment Member is the association of an Veterinary Establishment within a Veterinary Group.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentMemberResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentMemberBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentMember(Model\VeterinaryEstablishmentMemberRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentMember($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Member.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneVeterinaryEstablishmentMemberBadRequestException
     * @throws Exception\DeleteOneVeterinaryEstablishmentMemberNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentMember(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneVeterinaryEstablishmentMember($id, $headerParameters), $fetch);
    }

    /**
     * Search on Veterinary Establishment Members.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentName[] Filter by veterinaryEstablishmentName
     * @var array  $veterinaryEstablishmentPrivilegedCode[] Filter by veterinaryEstablishmentPrivilegedCode
     * @var array  $veterinaryGroupId[] Filter by veterinaryGroupId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryEstablishmentName Sort by veterinaryEstablishmentName.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentMemberResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\SearchVeterinaryEstablishmentMemberBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function searchVeterinaryEstablishmentMember(Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\SearchVeterinaryEstablishmentMember($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * List VeterinaryEstablishmentServicePeriods.
     * A VeterinaryEstablishmentServicePeriod represents a period, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryEstablishmentServiceSubscriptionId[] Filter by veterinaryEstablishmentServiceSubscriptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromStartDate[] Filter from startDate
     * @var array  $fromEndDate[] Filter from endDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toStartDate[] Filter to startDate
     * @var array  $toEndDate[] Filter to endDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortStartDate sort by startDate
     * @var string $sortEndDate sort by endDate
     * @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServicePeriodResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentServicePeriodBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentServicePeriod(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentServicePeriod($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List VeterinaryEstablishmentServiceSubscriptions.
     * A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $fromStartDate[] Filter from startDate
     * @var array  $fromEndDate[] Filter from endDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var array  $toStartDate[] Filter to startDate
     * @var array  $toEndDate[] Filter to endDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortVeterinaryServiceOptionEntitled Sort by veterinaryServiceOptionEntitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentServiceSubscription(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentServiceSubscription($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a VeterinaryEstablishmentServiceSubscription.
     * A VeterinaryEstablishmentServiceSubscription represents a subscription, a contract with a fixed duration for an
     * establishment to a set of service options.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryEstablishmentServiceSubscriptionResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentServiceSubscription(Model\VeterinaryEstablishmentServiceSubscriptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentServiceSubscription($requestBody, $headerParameters), $fetch);
    }

    /**
     * Reduce a Veterinary Establishment Service Subscription by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentServiceSubscriptionReductionResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\ReduceOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws Exception\ReduceOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function reduceOneVeterinaryEstablishmentServiceSubscription(string $id, Model\VeterinaryEstablishmentServiceSubscriptionReductionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\ReduceOneVeterinaryEstablishmentServiceSubscription($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Veterinary Establishment Service Subscription.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws Exception\DeleteOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOneVeterinaryEstablishmentServiceSubscription(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOneVeterinaryEstablishmentServiceSubscription($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Establishment Service Subscription by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryEstablishmentServiceSubscriptionResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryEstablishmentServiceSubscriptionBadRequestException
     * @throws Exception\UpdateOneVeterinaryEstablishmentServiceSubscriptionNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryEstablishmentServiceSubscription(string $id, Model\SchemasVeterinaryEstablishmentServiceSubscriptionRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryEstablishmentServiceSubscription($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Establishment Tags.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagResponse[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryEstablishmentTagBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryEstablishmentTag(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryEstablishmentTag($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Establishment Tag.
     * This endpoint will also create a Veterinary Establishment Tag.
     * A tag makes it possible to categorise a set of veterinary establishments around a keyword.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryEstablishmentTagBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryEstablishmentTag(Model\VeterinaryEstablishmentTagRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryEstablishmentTag($requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Veterinary Establishment Tag by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryEstablishmentTagResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetOneVeterinaryEstablishmentTagBadRequestException
     * @throws Exception\GetOneVeterinaryEstablishmentTagNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneVeterinaryEstablishmentTag(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneVeterinaryEstablishmentTag($id, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Groups.
     * A Veterinary Group is a network of Veterinary Establishments.
     * A Veterinary Establishment may belong to several Veterinary Groups.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $vguUser[] Filter by jobTitle of veterinary group user
     * @var array  $id[] Filter by id
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $vguUserId[] Filter by userId of Veterinary Group User
     * @var array  $entitled[] Filter by entitled
     * @var array  $groupCode[] Filter by groupCode
     * @var array  $veterinaryEstablishmentMemberId[] Filter by veterinaryEstablishmentMemberId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortGroupCode sort by groupCode
     * @var string $sortName sort by name
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryGroupResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryGroupBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryGroup(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryGroup($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create a Veterinary Group.
     * A Veterinary Group is a network of Veterinary Establishments.
     * A Veterinary Establishment may belong to several Veterinary Groups.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\SchemasVeterinaryGroupResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostVeterinaryGroupBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postVeterinaryGroup(Model\VeterinaryGroupRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostVeterinaryGroup($requestBody, $headerParameters), $fetch);
    }

    /**
     * Get a Veterinary Group by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryGroupResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetOneVeterinaryGroupBadRequestException
     * @throws Exception\GetOneVeterinaryGroupNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getOneVeterinaryGroup(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetOneVeterinaryGroup($id, $headerParameters), $fetch);
    }

    /**
     * Update a Veterinary Group by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ComponentsSchemasVeterinaryGroupResponse|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOneVeterinaryGroupNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOneVeterinaryGroup(string $id, Model\SchemasVeterinaryGroupRequest $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOneVeterinaryGroup($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Search on Veterinary Groups.
     * A veterinary group is a company, enterprise, association identifiable by a legalCode.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $entitled[] Filter by entitled
     * @var array  $groupCode[] Filter by groupCode
     * @var array  $veterinaryEstablishmentId[] Filter by veterinaryEstablishmentId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortEntryNumber sort by entryNumber
     * @var string $sortGroupCode sort by groupCode
     * @var string $sortName sort by name
     * @var string $sortType sort by type
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryGroupResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\SearchVeterinaryGroupBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function searchVeterinaryGroup(Model\SearchRequest $requestBody, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\SearchVeterinaryGroup($requestBody, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Services.
     * A veterinary service could be MyVetshop, Crockit, VetoPartner...
     * Each veterinary service proposes one or more options that can be subscribed to by an veterinary establishment or
     * a veterinary group. A service cannot be created through the api as it requires integration of the service into the
     * reef eco-system.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceOptionStatus[]
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryServiceResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryServiceBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryService(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryService($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Veterinary Service Options.
     * A veterinary service option could be access to an online shop, to negotiating pricing.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $veterinaryServiceId[] Filter by veterinaryServiceId
     * @var array  $status[]
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate sort by updatedDate
     * @var string $sortEntitled Sort by Entitled.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryServiceOptionBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryServiceOption(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryServiceOption($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List VeterinaryServiceOptionConfigs.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $veterinaryServiceOptionId[] Filter by veterinaryServiceOptionId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\VeterinaryServiceOptionConfigResponseItem[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllVeterinaryServiceOptionConfigBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllVeterinaryServiceOptionConfig(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllVeterinaryServiceOptionConfig($queryParameters, $headerParameters), $fetch);
    }

    /**
     * List Pets.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetBadRequestException
     * @throws Exception\GetAllPetInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPet(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPet($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an Pet.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetBadRequestException
     * @throws Exception\PostPetInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPet(Model\V1PetsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPet($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Pet by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetsIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOnePetBadRequestException
     * @throws Exception\UpdateOnePetNotFoundException
     * @throws Exception\UpdateOnePetInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOnePet(string $id, Model\V1PetsIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOnePet($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Pet Breeds.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $code[] Filter by code
     * @var array  $name[] Filter by name
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetBreedsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetBreedBadRequestException
     * @throws Exception\GetAllPetBreedInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetBreed(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetBreed($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an PetBreed.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetBreedBadRequestException
     * @throws Exception\PostPetBreedInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetBreed(Model\V1PetBreedsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetBreed($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Pet Breed.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOnePetBreedBadRequestException
     * @throws Exception\DeleteOnePetBreedNotFoundException
     * @throws Exception\DeleteOnePetBreedInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOnePetBreed(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOnePetBreed($id, $headerParameters), $fetch);
    }

    /**
     * List Pet Breed External Links.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $petBreedId[] Filter by petBreedId
     * @var array  $externalRefId[] Filter by externalRefId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetBreedExternalLinkBadRequestException
     * @throws Exception\GetAllPetBreedExternalLinkInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetBreedExternalLink(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetBreedExternalLink($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an PetBreedExternalLink.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedExternalLinksPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetBreedExternalLinkBadRequestException
     * @throws Exception\PostPetBreedExternalLinkInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetBreedExternalLink(Model\V1PetBreedExternalLinksPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetBreedExternalLink($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Pet Breed External Link.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOnePetBreedExternalLinkBadRequestException
     * @throws Exception\DeleteOnePetBreedExternalLinkNotFoundException
     * @throws Exception\DeleteOnePetBreedExternalLinkInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOnePetBreedExternalLink(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOnePetBreedExternalLink($id, $headerParameters), $fetch);
    }

    /**
     * List Pet Breed External Refs.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $name[] Filter by name
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetBreedExternalRefBadRequestException
     * @throws Exception\GetAllPetBreedExternalRefInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetBreedExternalRef(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetBreedExternalRef($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an PetBreedExternalRef.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedExternalRefsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetBreedExternalRefBadRequestException
     * @throws Exception\PostPetBreedExternalRefInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetBreedExternalRef(Model\V1PetBreedExternalRefsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetBreedExternalRef($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Pet Breed External Ref.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOnePetBreedExternalRefBadRequestException
     * @throws Exception\DeleteOnePetBreedExternalRefNotFoundException
     * @throws Exception\DeleteOnePetBreedExternalRefInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOnePetBreedExternalRef(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOnePetBreedExternalRef($id, $headerParameters), $fetch);
    }

    /**
     * List Pet Breed Labellings.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $petBreedId[] Filter by petBreedId
     * @var array  $tagId[] Filter by tagId
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetBreedLabellingsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetBreedLabellingBadRequestException
     * @throws Exception\GetAllPetBreedLabellingInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetBreedLabelling(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetBreedLabelling($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an PetBreedLabelling.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedLabellingsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetBreedLabellingBadRequestException
     * @throws Exception\PostPetBreedLabellingInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetBreedLabelling(Model\V1PetBreedLabellingsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetBreedLabelling($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Pet Breed Labelling.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOnePetBreedLabellingBadRequestException
     * @throws Exception\DeleteOnePetBreedLabellingNotFoundException
     * @throws Exception\DeleteOnePetBreedLabellingInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOnePetBreedLabelling(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOnePetBreedLabelling($id, $headerParameters), $fetch);
    }

    /**
     * List Pet Breed Tags.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $name[] Filter by name
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedTagsGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetBreedTagsGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetBreedTagBadRequestException
     * @throws Exception\GetAllPetBreedTagInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetBreedTag(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetBreedTag($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an PetBreedTag.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetBreedTagsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetBreedTagBadRequestException
     * @throws Exception\PostPetBreedTagInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetBreedTag(Model\V1PetBreedTagsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetBreedTag($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Pet Breed Tag.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOnePetBreedTagBadRequestException
     * @throws Exception\DeleteOnePetBreedTagNotFoundException
     * @throws Exception\DeleteOnePetBreedTagInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOnePetBreedTag(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOnePetBreedTag($id, $headerParameters), $fetch);
    }

    /**
     * Create an Pet Microchip.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetMicrochipsPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetMicrochipBadRequestException
     * @throws Exception\PostPetMicrochipInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetMicrochip(Model\V1PetMicrochipsPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetMicrochip($requestBody, $headerParameters), $fetch);
    }

    /**
     * Delete a Pet Microchip.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\DeleteOnePetMicrochipBadRequestException
     * @throws Exception\DeleteOnePetMicrochipNotFoundException
     * @throws Exception\DeleteOnePetMicrochipInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function deleteOnePetMicrochip(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\DeleteOnePetMicrochip($id, $headerParameters), $fetch);
    }

    /**
     * List Pet Profiles.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $type[] Filter by pet profile type
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetProfilesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetProfileBadRequestException
     * @throws Exception\GetAllPetProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetProfile(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetProfile($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Create an PetCustomerProfile.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetCustomerProfileBadRequestException
     * @throws Exception\PostPetCustomerProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetCustomerProfile(Model\V1PetCustomerProfilesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetCustomerProfile($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Pet Customer Profile by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetCustomerProfilesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOnePetCustomerProfileBadRequestException
     * @throws Exception\UpdateOnePetCustomerProfileNotFoundException
     * @throws Exception\UpdateOnePetCustomerProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOnePetCustomerProfile(string $id, Model\V1PetCustomerProfilesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOnePetCustomerProfile($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Create an PetGhostProfile.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetGhostProfilesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetGhostProfileBadRequestException
     * @throws Exception\PostPetGhostProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetGhostProfile(Model\V1PetGhostProfilesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetGhostProfile($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Pet Ghost Profile by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetGhostProfilesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOnePetGhostProfileBadRequestException
     * @throws Exception\UpdateOnePetGhostProfileNotFoundException
     * @throws Exception\UpdateOnePetGhostProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOnePetGhostProfile(string $id, Model\V1PetGhostProfilesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOnePetGhostProfile($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Create an PetPatientProfile.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetPatientProfilesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetPatientProfileBadRequestException
     * @throws Exception\PostPetPatientProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetPatientProfile(Model\V1PetPatientProfilesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetPatientProfile($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Pet Patient Profile by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetPatientProfilesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOnePetPatientProfileBadRequestException
     * @throws Exception\UpdateOnePetPatientProfileNotFoundException
     * @throws Exception\UpdateOnePetPatientProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOnePetPatientProfile(string $id, Model\V1PetPatientProfilesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOnePetPatientProfile($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * Create an PetPublicProfile.
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetPublicProfilesPostResponse201|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPetPublicProfileBadRequestException
     * @throws Exception\PostPetPublicProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPetPublicProfile(Model\V1PetPublicProfilesPostBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPetPublicProfile($requestBody, $headerParameters), $fetch);
    }

    /**
     * Update a Pet Public Profile by ID.
     *
     * @param string $id               the resource ID
     * @param array  $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetPublicProfilesIdPatchResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UpdateOnePetPublicProfileBadRequestException
     * @throws Exception\UpdateOnePetPublicProfileNotFoundException
     * @throws Exception\UpdateOnePetPublicProfileInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function updateOnePetPublicProfile(string $id, Model\V1PetPublicProfilesIdPatchBody $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\UpdateOnePetPublicProfile($id, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List Pet Species.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $id[] Filter by id
     * @var array  $name[] Filter by name
     * @var array  $category[] Filter by category
     * @var array  $code[] Filter by code
     * @var array  $fromCreatedDate[] Filter from createdDate
     * @var array  $fromUpdatedDate[] Filter from updatedDate
     * @var array  $toCreatedDate[] Filter to createdDate
     * @var array  $toUpdatedDate[] Filter to updatedDate
     * @var string $sortCreatedDate sort by createdDate
     * @var string $sortUpdatedDate Sort by updatedDate.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\V1PetSpeciesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllPetSpecieBadRequestException
     * @throws Exception\GetAllPetSpecieInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllPetSpecie(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllPetSpecie($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Client resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\ClientGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetClientItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getClientItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetClientItem($slug, $accept), $fetch);
    }

    /**
     * Update client resources types and allowed permissions.
     *
     * @param string $slug             Resource identifier
     * @param array  $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\PutDefinitionClientItemBadRequestException
     * @throws Exception\PutDefinitionClientItemUnprocessableEntityException
     * @throws Exception\PutDefinitionClientItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function putDefinitionClientItem(string $slug, Model\ServiceDefinition $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PutDefinitionClientItem($slug, $requestBody, $headerParameters), $fetch);
    }

    /**
     * List policy results stored in the IAM.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $name
     * @var array  $name[]
     * @var string $subject
     * @var array  $subject[]
     * @var string $etag
     * @var array  $etag[]
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPolicyResultCollection(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetPolicyResultCollection($queryParameters, $headerParameters, $accept), $fetch);
    }

    /**
     * Store a policy result in the IAM.
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPolicyResultCollectionBadRequestException
     * @throws Exception\PostPolicyResultCollectionUnprocessableEntityException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPolicyResultCollection(Model\PolicyResultPolicyResultPost $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\PostPolicyResultCollection($requestBody, $headerParameters, $accept), $fetch);
    }

    /**
     * Get a specific policy result.
     *
     * @param string $id               Resource identifier
     * @param array  $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\PolicyResultPolicyResultGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetPolicyResultItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPolicyResultItem(string $id, array $headerParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetPolicyResultItem($id, $headerParameters, $accept), $fetch);
    }

    /**
     * Retrieves the collection of Principal resources.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $email
     * @var string $status
     * @var array  $status[]
     * @var string $id
     * @var string $id[]
     * @var string $order[id]
     * @var string $order[email]
     * @var string $order[created]
     * @var string $order[updated]
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPrincipalCollection(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetPrincipalCollection($queryParameters), $fetch);
    }

    /**
     * Invite a person to join the reef by validating a pre-created account.
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostPrincipalCollectionBadRequestException
     * @throws Exception\PostPrincipalCollectionUnprocessableEntityException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postPrincipalCollection(Model\PrincipalShort $requestBody, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PostPrincipalCollection($requestBody, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Principal resource.
     *
     * @param string $id    Resource identifier
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetPrincipalItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPrincipalItem(string $id, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetPrincipalItem($id), $fetch);
    }

    /**
     * Update a principal.
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PrincipalGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PutPrincipalItemBadRequestException
     * @throws Exception\PutPrincipalItemUnprocessableEntityException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function putPrincipalItem(Model\PrincipalPut $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PutPrincipalItem($requestBody), $fetch);
    }

    /**
     * Create a resource group.
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getResourceGroupCollection(Model\ResourceGroupPost $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetResourceGroupCollection($requestBody), $fetch);
    }

    /**
     * Read a resource group.
     *
     * @param string $slug  Resource group slug
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetResourceGroupItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getResourceGroupItem(string $slug, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetResourceGroupItem($slug), $fetch);
    }

    /**
     * Update a resource group.
     *
     * @param string $slug  Resource group slug
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PutResourceGroupItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function putResourceGroupItem(string $slug, Model\ResourceGroupPut $requestBody, string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\PutResourceGroupItem($slug, $requestBody), $fetch);
    }

    /**
     * Retrieves a ResourceGroup resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceGroupResourceGroupGet|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetPermissionsResourceGroupItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceGroupItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetPermissionsResourceGroupItem($slug, $accept), $fetch);
    }

    /**
     * Retrieves a ResourceType resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\ResourceTypeGetshort|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetResourceTypeItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getResourceTypeItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetResourceTypeItem($slug, $accept), $fetch);
    }

    /**
     * Retrieve effective permissions on alle resources a the specified resource type.
     *
     * @param string $slug            Resource identifier
     * @param array  $queryParameters {
     *
     * @var string $principal Principal ID (if different from the one doing the query)
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetDetailedPermissionsResourceTypeItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getDetailedPermissionsResourceTypeItem(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetDetailedPermissionsResourceTypeItem($slug, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves a ResourceType resource.
     *
     * @param string $slug            Resource identifier
     * @param array  $queryParameters {
     *
     * @var string $principal Principal ID (if different from the one doing the query)
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetPermissionsResourceTypeItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceTypeItem(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetPermissionsResourceTypeItem($slug, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves the collection of Resource resources.
     *
     * @param array $queryParameters {
     *
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $slug
     * @var array  $slug[]
     *             }
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getResourceCollection(array $queryParameters = [], string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetResourceCollection($queryParameters, $accept), $fetch);
    }

    /**
     * Creates a Resource resource.
     *
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PostResourceCollectionBadRequestException
     * @throws Exception\PostResourceCollectionUnprocessableEntityException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function postResourceCollection(Model\Resource $requestBody, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\PostResourceCollection($requestBody, $accept), $fetch);
    }

    /**
     * Retrieve effective permissions on a collection of resources.
     *
     * @param array $queryParameters {
     *
     * @var array  $slug[] List of resources you want permissions for
     * @var string $principal Principal ID (if different from the one doing the query)
     * @var int    $page The collection page number
     * @var int    $itemsPerPage The number of items per page
     * @var string $slug
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrantList|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceCollection(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetPermissionsResourceCollection($queryParameters, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetResourceItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getResourceItem(string $slug, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\GetResourceItem($slug, $accept), $fetch);
    }

    /**
     * Replaces the Resource resource.
     *
     * @param string $slug   Resource identifier
     * @param string $fetch  Fetch mode to use (can be OBJECT or RESPONSE)
     * @param array  $accept Accept content header application/json|text/html
     *
     * @return \NoahVet\Reef\Jane\Model\Resource|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\PutResourceItemBadRequestException
     * @throws Exception\PutResourceItemUnprocessableEntityException
     * @throws Exception\PutResourceItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function putResourceItem(string $slug, Model\Resource $requestBody, string $fetch = self::FETCH_OBJECT, array $accept = [])
    {
        return $this->executeEndpoint(new Endpoint\PutResourceItem($slug, $requestBody, $accept), $fetch);
    }

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug             Resource identifier
     * @param array  $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrant|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetDetailedPermissionsResourceItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getDetailedPermissionsResourceItem(string $slug, array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetDetailedPermissionsResourceItem($slug, $headerParameters), $fetch);
    }

    /**
     * Retrieves a Resource resource.
     *
     * @param string $slug            Resource identifier
     * @param array  $queryParameters {
     *
     * @var string $principal Principal ID (if different from the one doing the query)
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $X-Reef-Client-ID Public OAuth Client ID
     * @var string $X-Reef-Client-HMAC HMAC computed using hash_hmac('sha256', bearer, clientSecret)
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\PermissionGrant|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetPermissionsResourceItemNotFoundException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getPermissionsResourceItem(string $slug, array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetPermissionsResourceItem($slug, $queryParameters, $headerParameters), $fetch);
    }

    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Psr\Http\Message\ResponseInterface|null
     *
     * @throws Exception\RevokeBadRequestException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function revoke(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\Revoke(), $fetch);
    }

    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\UserinfoGetResponse200|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\UserinfoUnauthorizedException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function userinfo(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\Userinfo(), $fetch);
    }

    /**
     * List Product Prices.
     *
     * @param array $queryParameters {
     *
     * @var int    $page the page of items to collect a part of result set
     * @var int    $limit the maximum number of items to collect a part of result set
     * @var array  $alcyonProductCode[] Filter by alcyonProductCode
     * @var array  $centravetProductCode[] Filter by centravetProductCode
     * @var array  $covetoProductCode[] Filter by covetoProductCode
     * @var array  $ean[] Filter by ean
     * @var array  $gtin[] Filter by gtin
     * @var array  $fromCreated[] Filter from created
     * @var array  $fromUpdated[] Filter from updated
     * @var array  $toCreated[] Filter to created
     * @var array  $toUpdated[] Filter to updated
     * @var string $sortCreated sort by created
     * @var string $sortUpdated Sort by updated.
     *             }
     *
     * @param array $headerParameters {
     *
     * @var string $Accept-Language The current locale.
     *             }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \NoahVet\Reef\Jane\Model\ApiV1ProductPricesGetResponse200Item[]|\NoahVet\Reef\Jane\Model\ApiV1ProductPricesGetResponse206Item[]|\Psr\Http\Message\ResponseInterface
     *
     * @throws Exception\GetAllProductPriceBadRequestException
     * @throws Exception\GetAllProductPriceInternalServerErrorException
     * @throws Exception\UnexpectedStatusCodeException
     */
    public function getAllProductPrice(array $queryParameters = [], array $headerParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new Endpoint\GetAllProductPrice($queryParameters, $headerParameters), $fetch);
    }

    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (0 < \count($additionalPlugins)) {
                $plugins = \array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new Normalizer\JaneObjectNormalizer()];
        if (0 < \count($additionalNormalizers)) {
            $normalizers = \array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);

        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}
