<?php

declare(strict_types=1);

namespace NoahVet\Reef\HWI\OAuth\ResourceOwner;

use HWI\Bundle\OAuthBundle\OAuth\ResourceOwner\GenericOAuth2ResourceOwner;
use NoahVet\Reef\HWI\OAuth\Response\ReefUserResponse;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ReefResourceOwner extends GenericOAuth2ResourceOwner
{
    public const TYPE = 'noahvet';

    /**
     * @var array<string, array<int, string>|string|null>
     */
    protected array $paths = [
        'identifier' => 'identifier',
        'email' => 'email',
        'firstname' => 'given_name',
        'lastname' => 'family_name',
        'nickname' => 'nickname',
        'realname' => 'display_name',
    ];

    protected function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver->setDefaults([
            'authorization_url' => '{base_url}/oauth/v2/auth',
            'access_token_url' => '{base_url}/oauth/v2/token',
            'infos_url' => '{base_url}/userinfo',
            'revoke_token_url' => '{base_url}/oauth/v2/revoke',
            'scope' => '',
            'user_response_class' => ReefUserResponse::class,
            'auth_with_one_url' => true,
            'csrf' => false,
            'refresh_on_expire' => true,
        ]);

        $resolver->setRequired([
            'base_url',
        ]);

        $normalizer = fn (Options $options, $value) => \str_replace('{base_url}', $options['base_url'], $value);

        $resolver
            ->setNormalizer('authorization_url', $normalizer)
            ->setNormalizer('access_token_url', $normalizer)
            ->setNormalizer('revoke_token_url', $normalizer)
            ->setNormalizer('infos_url', $normalizer)
        ;
    }
}
